import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::FinSpace::Environment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::FinSpace::Environment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-name
     */
    readonly name: string;
    /**
     * `AWS::FinSpace::Environment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-description
     */
    readonly description?: string;
    /**
     * `AWS::FinSpace::Environment.FederationMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationmode
     */
    readonly federationMode?: string;
    /**
     * `AWS::FinSpace::Environment.FederationParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationparameters
     */
    readonly federationParameters?: CfnEnvironment.FederationParametersProperty | cdk.IResolvable;
    /**
     * `AWS::FinSpace::Environment.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-kmskeyid
     */
    readonly kmsKeyId?: string;
}
/**
 * A CloudFormation `AWS::FinSpace::Environment`.
 *
 * @external
 * @cloudformationResource AWS::FinSpace::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FinSpace::Environment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironment;
    /**
     * @external
     * @cloudformationAttribute AwsAccountId
     */
    readonly attrAwsAccountId: string;
    /**
     * @external
     * @cloudformationAttribute DedicatedServiceAccountId
     */
    readonly attrDedicatedServiceAccountId: string;
    /**
     * @external
     * @cloudformationAttribute EnvironmentArn
     */
    readonly attrEnvironmentArn: string;
    /**
     * @external
     * @cloudformationAttribute EnvironmentId
     */
    readonly attrEnvironmentId: string;
    /**
     * @external
     * @cloudformationAttribute EnvironmentUrl
     */
    readonly attrEnvironmentUrl: string;
    /**
     * @external
     * @cloudformationAttribute SageMakerStudioDomainUrl
     */
    readonly attrSageMakerStudioDomainUrl: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::FinSpace::Environment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-name
     */
    name: string;
    /**
     * `AWS::FinSpace::Environment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-description
     */
    description: string | undefined;
    /**
     * `AWS::FinSpace::Environment.FederationMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationmode
     */
    federationMode: string | undefined;
    /**
     * `AWS::FinSpace::Environment.FederationParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationparameters
     */
    federationParameters: CfnEnvironment.FederationParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FinSpace::Environment.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * Create a new `AWS::FinSpace::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::FinSpace::Environment`.
 *
 * @external
 * @cloudformationResource AWS::FinSpace::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html
     */
    interface FederationParametersProperty {
        /**
         * `CfnEnvironment.FederationParametersProperty.ApplicationCallBackURL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-applicationcallbackurl
         */
        readonly applicationCallBackUrl?: string;
        /**
         * `CfnEnvironment.FederationParametersProperty.AttributeMap`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-attributemap
         */
        readonly attributeMap?: any | cdk.IResolvable;
        /**
         * `CfnEnvironment.FederationParametersProperty.FederationProviderName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-federationprovidername
         */
        readonly federationProviderName?: string;
        /**
         * `CfnEnvironment.FederationParametersProperty.FederationURN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-federationurn
         */
        readonly federationUrn?: string;
        /**
         * `CfnEnvironment.FederationParametersProperty.SamlMetadataDocument`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-samlmetadatadocument
         */
        readonly samlMetadataDocument?: string;
        /**
         * `CfnEnvironment.FederationParametersProperty.SamlMetadataURL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-finspace-environment-federationparameters.html#cfn-finspace-environment-federationparameters-samlmetadataurl
         */
        readonly samlMetadataUrl?: string;
    }
}
