"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeEventPattern = void 0;
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat and deduplicate the values
            if (Array.isArray(srcValue)) {
                const result = [...destValue, ...srcValue];
                const resultJson = result.map(i => JSON.stringify(i));
                destObj[field] = result.filter((value, index) => resultJson.indexOf(JSON.stringify(value)) === index);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,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