import { EventPattern } from './event-pattern';
import { IRuleTarget } from './target';
/**
 * (experimental) Standard set of options for `onXxx` event handlers on construct.
 *
 * @experimental
 */
export interface OnEventOptions {
    /**
     * (experimental) The target to register for the event.
     *
     * @default - No target is added to the rule. Use `addTarget()` to add a target.
     * @experimental
     */
    readonly target?: IRuleTarget;
    /**
     * (experimental) A description of the rule's purpose.
     *
     * @default - No description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) A name for the rule.
     *
     * @default AWS CloudFormation generates a unique physical ID.
     * @experimental
     */
    readonly ruleName?: string;
    /**
     * (experimental) Additional restrictions for the event to route to the specified target.
     *
     * The method that generates the rule probably imposes some type of event
     * filtering. The filtering implied by what you pass here is added
     * on top of that filtering.
     *
     * @default - No additional filtering based on an event pattern.
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html
     * @experimental
     */
    readonly eventPattern?: EventPattern;
}
