import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { Archive, BaseArchiveProps } from './archive';
/**
 * (experimental) Interface which all EventBus based classes MUST implement.
 *
 * @experimental
 */
export interface IEventBus extends IResource {
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The JSON policy of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
    /**
     * (experimental) Create an EventBridge archive to send events to.
     *
     * When you create an archive, incoming events might not immediately start being sent to the archive.
     * Allow a short period of time for changes to take effect.
     *
     * @param props Properties of the archive.
     * @experimental
     */
    archive(id: string, props: BaseArchiveProps): Archive;
    /**
     * (experimental) Grants an IAM Principal to send custom events to the eventBus so that they can be matched to rules.
     *
     * @param grantee The principal (no-op if undefined).
     * @experimental
     */
    grantPutEventsTo(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Properties to define an event bus.
 *
 * @experimental
 */
export interface EventBusProps {
    /**
     * (experimental) The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
     *
     * @default - automatically generated name
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName?: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
     *
     * @default - no partner event source
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * (experimental) Interface with properties necessary to import a reusable EventBus.
 *
 * @experimental
 */
export interface EventBusAttributes {
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The JSON policy of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource.
     *
     * @default - no partner event source
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
declare abstract class EventBusBase extends Resource implements IEventBus {
    /**
     * The physical ID of this event bus resource
     */
    abstract readonly eventBusName: string;
    /**
     * The ARN of the event bus, such as:
     * arn:aws:events:us-east-2:123456789012:event-bus/aws.partner/PartnerName/acct1/repo1.
     */
    abstract readonly eventBusArn: string;
    /**
     * The policy for the event bus in JSON form.
     */
    abstract readonly eventBusPolicy: string;
    /**
     * The name of the partner event source
     */
    abstract readonly eventSourceName?: string;
    /**
     * (experimental) Create an EventBridge archive to send events to.
     *
     * When you create an archive, incoming events might not immediately start being sent to the archive.
     * Allow a short period of time for changes to take effect.
     *
     * @experimental
     */
    archive(id: string, props: BaseArchiveProps): Archive;
    /**
     * (experimental) Grants an IAM Principal to send custom events to the eventBus so that they can be matched to rules.
     *
     * @experimental
     */
    grantPutEventsTo(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Define an EventBridge EventBus.
 *
 * @experimental
 * @resource AWS::Events::EventBus
 */
export declare class EventBus extends EventBusBase {
    /**
     * (experimental) Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param eventBusArn ARN of imported event bus.
     * @experimental
     */
    static fromEventBusArn(scope: Construct, id: string, eventBusArn: string): IEventBus;
    /**
     * (experimental) Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param attrs Imported event bus properties.
     * @experimental
     */
    static fromEventBusAttributes(scope: Construct, id: string, attrs: EventBusAttributes): IEventBus;
    /**
     * (deprecated) Permits an IAM Principal to send custom events to EventBridge so that they can be matched to rules.
     *
     * @param grantee The principal (no-op if undefined).
     * @deprecated use grantAllPutEvents instead
     */
    static grantPutEvents(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM Principal to send custom events to EventBridge so that they can be matched to rules.
     *
     * @param grantee The principal (no-op if undefined).
     * @experimental
     */
    static grantAllPutEvents(grantee: iam.IGrantable): iam.Grant;
    private static eventBusProps;
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of the event bus, such as: arn:aws:events:us-east-2:123456789012:event-bus/aws.partner/PartnerName/acct1/repo1.
     *
     * @experimental
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The policy for the event bus in JSON form.
     *
     * @experimental
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The name of the partner event source.
     *
     * @experimental
     */
    readonly eventSourceName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: EventBusProps);
}
export {};
