import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
import { IEventBus } from './event-bus';
import { EventPattern } from './event-pattern';
/**
 * (experimental) The event archive base properties.
 *
 * @experimental
 */
export interface BaseArchiveProps {
    /**
     * (experimental) The name of the archive.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly archiveName?: string;
    /**
     * (experimental) A description for the archive.
     *
     * @default - none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) An event pattern to use to filter events sent to the archive.
     *
     * @experimental
     */
    readonly eventPattern: EventPattern;
    /**
     * (experimental) The number of days to retain events for.
     *
     * Default value is 0. If set to 0, events are retained indefinitely.
     *
     * @default - Infinite
     * @experimental
     */
    readonly retention?: Duration;
}
/**
 * (experimental) The event archive properties.
 *
 * @experimental
 */
export interface ArchiveProps extends BaseArchiveProps {
    /**
     * (experimental) The event source associated with the archive.
     *
     * @experimental
     */
    readonly sourceEventBus: IEventBus;
}
/**
 * (experimental) Define an EventBridge Archive.
 *
 * @experimental
 * @resource AWS::Events::Archive
 */
export declare class Archive extends Resource {
    /**
     * (experimental) The archive name.
     *
     * @experimental
     * @attribute true
     */
    readonly archiveName: string;
    /**
     * (experimental) The ARN of the archive created.
     *
     * @experimental
     * @attribute true
     */
    readonly archiveArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ArchiveProps);
}
