import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as lambda from "../../aws-lambda";
import * as sqs from "../../aws-sqs";
import { IConstruct, Duration } from "../../core";
/**
 * (experimental) The generic properties for an RuleTarget.
 *
 * @experimental
 */
export interface TargetBaseProps {
    /**
     * (experimental) The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
     *
     * The events not successfully delivered are automatically retried for a specified period of time,
     * depending on the retry policy of the target.
     * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
     *
     * @default - no dead-letter queue
     * @experimental
     */
    readonly deadLetterQueue?: sqs.IQueue;
    /**
     * (experimental) The maximum age of a request that Lambda sends to a function for processing.
     *
     * Minimum value of 60.
     * Maximum value of 86400.
     *
     * @default Duration.hours(24)
     * @experimental
     */
    readonly maxEventAge?: Duration;
    /**
     * (experimental) The maximum number of times to retry when the function returns an error.
     *
     * Minimum value of 0.
     * Maximum value of 185.
     *
     * @default 185
     * @experimental
     */
    readonly retryAttempts?: number;
}
/**
 * Bind props to base rule target config.
 * @internal
 */
export declare function bindBaseTargetConfig(props: TargetBaseProps): {
    deadLetterConfig: {
        arn: string;
    } | undefined;
    retryPolicy: {
        maximumRetryAttempts: number | undefined;
        maximumEventAgeInSeconds: number | undefined;
    } | undefined;
};
/**
 * Obtain the Role for the EventBridge event
 *
 * If a role already exists, it will be returned. This ensures that if multiple
 * events have the same target, they will share a role.
 * @internal
 */
export declare function singletonEventRole(scope: IConstruct, policyStatements: iam.PolicyStatement[]): iam.IRole;
/**
 * Allows a Lambda function to be called from a rule
 * @internal
 */
export declare function addLambdaPermission(rule: events.IRule, handler: lambda.IFunction): void;
/**
 * Allow a rule to send events with failed invocation to an Amazon SQS queue.
 * @internal
 */
export declare function addToDeadLetterQueueResourcePolicy(rule: events.IRule, queue: sqs.IQueue): void;
