"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const util_1 = require("./util");
/**
 * (experimental) Use an AWS CloudWatch LogGroup as an event rule target.
 *
 * @experimental
 */
class CloudWatchLogGroup {
    /**
     * @experimental
     */
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup.
     *
     * @experimental
     */
    bind(_rule, _id) {
        // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
        const resourcePolicyId = `EventsLogGroupPolicy${_rule.node.uniqueId}`;
        const logGroupStack = cdk.Stack.of(this.logGroup);
        if (!this.logGroup.node.tryFindChild(resourcePolicyId)) {
            new log_group_resource_policy_1.LogGroupResourcePolicy(logGroupStack, resourcePolicyId, {
                policyStatements: [new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                        resources: [this.logGroup.logGroupArn],
                        principals: [new iam.ServicePrincipal('events.amazonaws.com')],
                    })],
            });
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: logGroupStack.formatArn({
                service: 'logs',
                resource: 'log-group',
                sep: ':',
                resourceName: this.logGroup.logGroupName,
            }),
            input: this.props.event,
            targetResource: this.logGroup,
        };
    }
}
exports.CloudWatchLogGroup = CloudWatchLogGroup;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogGroup[_a] = { fqn: "monocdk.aws_events_targets.CloudWatchLogGroup", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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