import * as events from "../../aws-events";
import * as logs from "../../aws-logs";
import { TargetBaseProps } from './util';
/**
 * (experimental) Customize the CloudWatch LogGroup Event Target.
 *
 * @experimental
 */
export interface LogGroupProps extends TargetBaseProps {
    /**
     * (experimental) The event to send to the CloudWatch LogGroup.
     *
     * This will be the event logged into the CloudWatch LogGroup
     *
     * @default - the entire EventBridge event
     * @experimental
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * (experimental) Use an AWS CloudWatch LogGroup as an event rule target.
 *
 * @experimental
 */
export declare class CloudWatchLogGroup implements events.IRuleTarget {
    private readonly logGroup;
    private readonly props;
    /**
     * @experimental
     */
    constructor(logGroup: logs.ILogGroup, props?: LogGroupProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
