"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogGroupResourcePolicy = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cr = require("../../custom-resources"); // Automatically re-written from '@aws-cdk/custom-resources'
/**
 * Creates LogGroup resource policies.
 */
class LogGroupResourcePolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.policyStatements,
        });
        let policyName = props.policyName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) });
        super(scope, id, {
            resourceType: 'Custom::CloudwatchLogResourcePolicy',
            onUpdate: {
                service: 'CloudWatchLogs',
                action: 'putResourcePolicy',
                parameters: {
                    policyName: policyName,
                    policyDocument: JSON.stringify(policyDocument),
                },
                physicalResourceId: cr.PhysicalResourceId.of(id),
            },
            onDelete: {
                service: 'CloudWatchLogs',
                action: 'deleteResourcePolicy',
                parameters: {
                    policyName: policyName,
                },
                ignoreErrorCodesMatching: '400',
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({
                // putResourcePolicy and deleteResourcePolicy don't support resource-level permissions. We must specify all resources ("*").
                // https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html
                resources: cr.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.LogGroupResourcePolicy = LogGroupResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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