"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Lambda function as an event rule target.
 *
 * @experimental
 */
class LambdaFunction {
    /**
     * @experimental
     */
    constructor(handler, props = {}) {
        this.handler = handler;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Lambda as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, this.handler);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.handler.functionArn,
            input: this.props.event,
            targetResource: this.handler,
        };
    }
}
exports.LambdaFunction = LambdaFunction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunction[_a] = { fqn: "monocdk.aws_events_targets.LambdaFunction", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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