"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @experimental
 * @example
 *
 *    // put to a Kinesis stream every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.KinesisStream(stream));
 */
class KinesisStream {
    /**
     * @experimental
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Kinesis Stream as a result from a CloudWatch event.
     *
     * @experimental
     */
    bind(_rule, _id) {
        const policyStatements = [new iam.PolicyStatement({
                actions: ['kinesis:PutRecord', 'kinesis:PutRecords'],
                resources: [this.stream.streamArn],
            })];
        return {
            arn: this.stream.streamArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
            kinesisParameters: this.props.partitionKeyPath ? { partitionKeyPath: this.props.partitionKeyPath } : undefined,
        };
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "monocdk.aws_events_targets.KinesisStream", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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