"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseStream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Customize the Firehose Stream Event Target.
 *
 * @experimental
 */
class KinesisFirehoseStream {
    /**
     * @experimental
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     *
     * @experimental
     */
    bind(_rule, _id) {
        const policyStatements = [new iam.PolicyStatement({
                actions: ['firehose:PutRecord', 'firehose:PutRecordBatch'],
                resources: [this.stream.attrArn],
            })];
        return {
            arn: this.stream.attrArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
        };
    }
}
exports.KinesisFirehoseStream = KinesisFirehoseStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseStream[_a] = { fqn: "monocdk.aws_events_targets.KinesisFirehoseStream", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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