"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBus = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Notify an existing Event Bus of an event.
 *
 * @experimental
 */
class EventBus {
    /**
     * @experimental
     */
    constructor(eventBus, props = {}) {
        this.eventBus = eventBus;
        this.role = props.role;
    }
    /**
     * (experimental) Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _b;
        if (this.role) {
            this.role.addToPrincipalPolicy(this.putEventStatement());
        }
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : util_1.singletonEventRole(rule, [this.putEventStatement()]);
        return {
            arn: this.eventBus.eventBusArn,
            role,
        };
    }
    putEventStatement() {
        return new iam.PolicyStatement({
            actions: ['events:PutEvents'],
            resources: [this.eventBus.eventBusArn],
        });
    }
}
exports.EventBus = EventBus;
_a = JSII_RTTI_SYMBOL_1;
EventBus[_a] = { fqn: "monocdk.aws_events_targets.EventBus", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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