import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
/**
 * (experimental) Configuration properties of an Event Bus event.
 *
 * @experimental
 */
export interface EventBusProps {
    /**
     * (experimental) Role to be used to publish the event.
     *
     * @default a new role is created.
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Notify an existing Event Bus of an event.
 *
 * @experimental
 */
export declare class EventBus implements events.IRuleTarget {
    private readonly eventBus;
    private readonly role?;
    /**
     * @experimental
     */
    constructor(eventBus: events.IEventBus, props?: EventBusProps);
    /**
     * (experimental) Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @experimental
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
    private putEventStatement;
}
