"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Allows the pipeline to be used as an EventBridge rule target.
 *
 * @experimental
 */
class CodePipeline {
    /**
     * @experimental
     */
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    /**
     * (experimental) Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @experimental
     */
    bind(_rule, _id) {
        return {
            ...util_1.bindBaseTargetConfig(this.options),
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
_a = JSII_RTTI_SYMBOL_1;
CodePipeline[_a] = { fqn: "monocdk.aws_events_targets.CodePipeline", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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