import * as codepipeline from "../../aws-codepipeline";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { TargetBaseProps } from './util';
/**
 * (experimental) Customization options when creating a {@link CodePipeline} event target.
 *
 * @experimental
 */
export interface CodePipelineTargetOptions extends TargetBaseProps {
    /**
     * (experimental) The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
     *
     * @default - a new role will be created
     * @experimental
     */
    readonly eventRole?: iam.IRole;
}
/**
 * (experimental) Allows the pipeline to be used as an EventBridge rule target.
 *
 * @experimental
 */
export declare class CodePipeline implements events.IRuleTarget {
    private readonly pipeline;
    private readonly options;
    /**
     * @experimental
     */
    constructor(pipeline: codepipeline.IPipeline, options?: CodePipelineTargetOptions);
    /**
     * (experimental) Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
