import * as codebuild from "../../aws-codebuild";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { TargetBaseProps } from './util';
/**
 * (experimental) Customize the CodeBuild Event Target.
 *
 * @experimental
 */
export interface CodeBuildProjectProps extends TargetBaseProps {
    /**
     * (experimental) The role to assume before invoking the target (i.e., the codebuild) when the given rule is triggered.
     *
     * @default - a new role will be created
     * @experimental
     */
    readonly eventRole?: iam.IRole;
    /**
     * (experimental) The event to send to CodeBuild.
     *
     * This will be the payload for the StartBuild API.
     *
     * @default - the entire EventBridge event
     * @experimental
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * (experimental) Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 *
 * @experimental
 */
export declare class CodeBuildProject implements events.IRuleTarget {
    private readonly project;
    private readonly props;
    /**
     * @experimental
     */
    constructor(project: codebuild.IProject, props?: CodeBuildProjectProps);
    /**
     * (experimental) Allows using build projects as event rule targets.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
