"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * Most likely the code will look something like this:
 * `new BatchJob(jobQueue.jobQueueArn, jobQueue, jobDefinition.jobDefinitionArn, jobDefinition)`
 *
 * In the future this API will be improved to be fully typed
 *
 * @experimental
 */
class BatchJob {
    /**
     * @param jobQueueArn The JobQueue arn.
     * @param jobQueueScope The JobQueue Resource.
     * @param jobDefinitionArn The jobDefinition arn.
     * @param jobDefinitionScope The JobQueue Resource.
     * @experimental
     */
    constructor(
    /**
     * The JobQueue arn
     */
    jobQueueArn, 
    /**
     * The JobQueue Resource
     */
    jobQueueScope, 
    /**
     * The jobDefinition arn
     */
    jobDefinitionArn, 
    /**
     * The JobQueue Resource
     */
    jobDefinitionScope, props = {}) {
        this.jobQueueArn = jobQueueArn;
        this.jobQueueScope = jobQueueScope;
        this.jobDefinitionArn = jobDefinitionArn;
        this.jobDefinitionScope = jobDefinitionScope;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _b;
        const batchParameters = {
            jobDefinition: this.jobDefinitionArn,
            jobName: (_b = this.props.jobName) !== null && _b !== void 0 ? _b : core_1.Names.nodeUniqueId(rule.node),
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            arn: this.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinitionScope, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinitionArn,
                        this.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueueScope,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
_a = JSII_RTTI_SYMBOL_1;
BatchJob[_a] = { fqn: "monocdk.aws_events_targets.BatchJob", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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