"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 *
 * @experimental
 */
class ApiGateway {
    /**
     * @experimental
     */
    constructor(restApi, props) {
        this.restApi = restApi;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this API Gateway REST APIs as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @experimental
     */
    bind(rule, _id) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        if ((_b = this.props) === null || _b === void 0 ? void 0 : _b.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        const wildcardCountsInPath = (_f = (_e = (_d = (_c = this.props) === null || _c === void 0 ? void 0 : _c.path) === null || _d === void 0 ? void 0 : _d.match(/\*/g)) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0;
        if (wildcardCountsInPath !== (((_g = this.props) === null || _g === void 0 ? void 0 : _g.pathParameterValues) || []).length) {
            throw new Error('The number of wildcards in the path does not match the number of path pathParameterValues.');
        }
        const restApiArn = this.restApi.arnForExecuteApi((_h = this.props) === null || _h === void 0 ? void 0 : _h.method, ((_j = this.props) === null || _j === void 0 ? void 0 : _j.path) || '/', ((_k = this.props) === null || _k === void 0 ? void 0 : _k.stage) || this.restApi.deploymentStage.stageName);
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: restApiArn,
            role: ((_l = this.props) === null || _l === void 0 ? void 0 : _l.eventRole) || util_1.singletonEventRole(this.restApi, [new iam.PolicyStatement({
                    resources: [restApiArn],
                    actions: [
                        'execute-api:Invoke',
                        'execute-api:ManageConnections',
                    ],
                })]),
            deadLetterConfig: ((_m = this.props) === null || _m === void 0 ? void 0 : _m.deadLetterQueue) && { arn: (_o = this.props.deadLetterQueue) === null || _o === void 0 ? void 0 : _o.queueArn },
            input: (_p = this.props) === null || _p === void 0 ? void 0 : _p.postBody,
            targetResource: this.restApi,
            httpParameters: {
                headerParameters: (_q = this.props) === null || _q === void 0 ? void 0 : _q.headerParameters,
                queryStringParameters: (_r = this.props) === null || _r === void 0 ? void 0 : _r.queryStringParameters,
                pathParameterValues: (_s = this.props) === null || _s === void 0 ? void 0 : _s.pathParameterValues,
            },
        };
    }
}
exports.ApiGateway = ApiGateway;
_a = JSII_RTTI_SYMBOL_1;
ApiGateway[_a] = { fqn: "monocdk.aws_events_targets.ApiGateway", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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