import * as api from "../../aws-apigateway";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { TargetBaseProps } from './util';
/**
 * (experimental) Customize the API Gateway Event Target.
 *
 * @experimental
 */
export interface ApiGatewayProps extends TargetBaseProps {
    /**
     * (experimental) The method for api resource invoked by the rule.
     *
     * @default '*' that treated as ANY
     * @experimental
     */
    readonly method?: string;
    /**
     * (experimental) The api resource invoked by the rule.
     *
     * We can use wildcards('*') to specify the path. In that case,
     * an equal number of real values must be specified for pathParameterValues.
     *
     * @default '/'
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The deploy stage of api gateway invoked by the rule.
     *
     * @default the value of deploymentStage.stageName of target api gateway.
     * @experimental
     */
    readonly stage?: string;
    /**
     * (experimental) The headers to be set when requesting API.
     *
     * @default no header parameters
     * @experimental
     */
    readonly headerParameters?: {
        [key: string]: (string);
    };
    /**
     * (experimental) The path parameter values to be used to populate to wildcards("*") of requesting api path.
     *
     * @default no path parameters
     * @experimental
     */
    readonly pathParameterValues?: string[];
    /**
     * (experimental) The query parameters to be set when requesting API.
     *
     * @default no querystring parameters
     * @experimental
     */
    readonly queryStringParameters?: {
        [key: string]: (string);
    };
    /**
     * (experimental) This will be the post request body send to the API.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly postBody?: events.RuleTargetInput;
    /**
     * (experimental) The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
     *
     * @default - a new role will be created
     * @experimental
     */
    readonly eventRole?: iam.IRole;
}
/**
 * (experimental) Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 *
 * @experimental
 */
export declare class ApiGateway implements events.IRuleTarget {
    readonly restApi: api.RestApi;
    private readonly props?;
    /**
     * @experimental
     */
    constructor(restApi: api.RestApi, props?: ApiGatewayProps | undefined);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this API Gateway REST APIs as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @experimental
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
