import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::EMRContainers::VirtualCluster`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html
 */
export interface CfnVirtualClusterProps {
    /**
     * `AWS::EMRContainers::VirtualCluster.ContainerProvider`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-containerprovider
     */
    readonly containerProvider: CfnVirtualCluster.ContainerProviderProperty | cdk.IResolvable;
    /**
     * `AWS::EMRContainers::VirtualCluster.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-name
     */
    readonly name: string;
    /**
     * `AWS::EMRContainers::VirtualCluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EMRContainers::VirtualCluster`.
 *
 * @external
 * @cloudformationResource AWS::EMRContainers::VirtualCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html
 */
export declare class CfnVirtualCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EMRContainers::VirtualCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualCluster;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EMRContainers::VirtualCluster.ContainerProvider`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-containerprovider
     */
    containerProvider: CfnVirtualCluster.ContainerProviderProperty | cdk.IResolvable;
    /**
     * `AWS::EMRContainers::VirtualCluster.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-name
     */
    name: string;
    /**
     * `AWS::EMRContainers::VirtualCluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EMRContainers::VirtualCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EMRContainers::VirtualCluster`.
 *
 * @external
 * @cloudformationResource AWS::EMRContainers::VirtualCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html
 */
export declare namespace CfnVirtualCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerinfo.html
     */
    interface ContainerInfoProperty {
        /**
         * `CfnVirtualCluster.ContainerInfoProperty.EksInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerinfo.html#cfn-emrcontainers-virtualcluster-containerinfo-eksinfo
         */
        readonly eksInfo: CfnVirtualCluster.EksInfoProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EMRContainers::VirtualCluster`.
 *
 * @external
 * @cloudformationResource AWS::EMRContainers::VirtualCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html
 */
export declare namespace CfnVirtualCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerprovider.html
     */
    interface ContainerProviderProperty {
        /**
         * `CfnVirtualCluster.ContainerProviderProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerprovider.html#cfn-emrcontainers-virtualcluster-containerprovider-id
         */
        readonly id: string;
        /**
         * `CfnVirtualCluster.ContainerProviderProperty.Info`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerprovider.html#cfn-emrcontainers-virtualcluster-containerprovider-info
         */
        readonly info: CfnVirtualCluster.ContainerInfoProperty | cdk.IResolvable;
        /**
         * `CfnVirtualCluster.ContainerProviderProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-containerprovider.html#cfn-emrcontainers-virtualcluster-containerprovider-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EMRContainers::VirtualCluster`.
 *
 * @external
 * @cloudformationResource AWS::EMRContainers::VirtualCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html
 */
export declare namespace CfnVirtualCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-eksinfo.html
     */
    interface EksInfoProperty {
        /**
         * `CfnVirtualCluster.EksInfoProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrcontainers-virtualcluster-eksinfo.html#cfn-emrcontainers-virtualcluster-eksinfo-namespace
         */
        readonly namespace: string;
    }
}
