"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticMapReduceMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ElasticMapReduceMetrics {
    static jobsRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'JobsRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static jobsFailedAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'JobsFailed',
            dimensions,
            statistic: 'Average',
        };
    }
    static isIdleAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'IsIdle',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapTasksRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapTasksRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapTasksRemainingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapTasksRemaining',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapSlotsOpenAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapSlotsOpen',
            dimensions,
            statistic: 'Average',
        };
    }
    static remainingMapTasksPerSlotAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'RemainingMapTasksPerSlot',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceTasksRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceTasksRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceTasksRemainingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceTasksRemaining',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceSlotsOpenAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceSlotsOpen',
            dimensions,
            statistic: 'Average',
        };
    }
    static coreNodesRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'CoreNodesRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static coreNodesPendingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'CoreNodesPending',
            dimensions,
            statistic: 'Average',
        };
    }
    static liveDataNodesAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'LiveDataNodes',
            dimensions,
            statistic: 'Average',
        };
    }
    static taskNodesRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TaskNodesRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static taskNodesPendingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TaskNodesPending',
            dimensions,
            statistic: 'Average',
        };
    }
    static liveTaskTrackersAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'LiveTaskTrackers',
            dimensions,
            statistic: 'Average',
        };
    }
    static s3BytesWrittenSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'S3BytesWritten',
            dimensions,
            statistic: 'Sum',
        };
    }
    static s3BytesReadSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'S3BytesRead',
            dimensions,
            statistic: 'Sum',
        };
    }
    static hdfsUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static hdfsBytesReadSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSBytesRead',
            dimensions,
            statistic: 'Sum',
        };
    }
    static hdfsBytesWrittenSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSBytesWritten',
            dimensions,
            statistic: 'Sum',
        };
    }
    static missingBlocksAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MissingBlocks',
            dimensions,
            statistic: 'Average',
        };
    }
    static totalLoadAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TotalLoad',
            dimensions,
            statistic: 'Average',
        };
    }
    static backupFailedAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'BackupFailed',
            dimensions,
            statistic: 'Average',
        };
    }
    static mostRecentBackupDurationAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MostRecentBackupDuration',
            dimensions,
            statistic: 'Average',
        };
    }
    static timeSinceLastSuccessfulBackupAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TimeSinceLastSuccessfulBackup',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.ElasticMapReduceMetrics = ElasticMapReduceMetrics;
//# sourceMappingURL=data:application/json;base64,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