import * as acm from "../../aws-certificatemanager";
import { Metric, MetricOptions } from "../../aws-cloudwatch";
import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import * as logs from "../../aws-logs";
import * as route53 from "../../aws-route53";
import * as cdk from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Elasticsearch version.
 *
 * @experimental
 */
export declare class ElasticsearchVersion {
    readonly version: string;
    /**
     * (experimental) AWS Elasticsearch 1.5.
     *
     * @experimental
     */
    static readonly V1_5: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 2.3.
     *
     * @experimental
     */
    static readonly V2_3: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 5.1.
     *
     * @experimental
     */
    static readonly V5_1: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 5.3.
     *
     * @experimental
     */
    static readonly V5_3: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 5.5.
     *
     * @experimental
     */
    static readonly V5_5: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 5.6.
     *
     * @experimental
     */
    static readonly V5_6: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.0.
     *
     * @experimental
     */
    static readonly V6_0: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.2.
     *
     * @experimental
     */
    static readonly V6_2: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.3.
     *
     * @experimental
     */
    static readonly V6_3: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.4.
     *
     * @experimental
     */
    static readonly V6_4: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.5.
     *
     * @experimental
     */
    static readonly V6_5: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.7.
     *
     * @experimental
     */
    static readonly V6_7: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 6.8.
     *
     * @experimental
     */
    static readonly V6_8: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.1.
     *
     * @experimental
     */
    static readonly V7_1: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.4.
     *
     * @experimental
     */
    static readonly V7_4: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.7.
     *
     * @experimental
     */
    static readonly V7_7: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.8.
     *
     * @experimental
     */
    static readonly V7_8: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.9.
     *
     * @experimental
     */
    static readonly V7_9: ElasticsearchVersion;
    /**
     * (experimental) AWS Elasticsearch 7.10.
     *
     * @experimental
     */
    static readonly V7_10: ElasticsearchVersion;
    /**
     * (experimental) Custom Elasticsearch version.
     *
     * @param version custom version number.
     * @experimental
     */
    static of(version: string): ElasticsearchVersion;
    /**
     *
     * @param version Elasticsearch version number
     */
    private constructor();
}
/**
 * (experimental) Configures the capacity of the cluster such as the instance type and the number of instances.
 *
 * @experimental
 */
export interface CapacityConfig {
    /**
     * (experimental) The number of instances to use for the master node.
     *
     * @default - no dedicated master nodes
     * @experimental
     */
    readonly masterNodes?: number;
    /**
     * (experimental) The hardware configuration of the computer that hosts the dedicated master node, such as `m3.medium.elasticsearch`. For valid values, see [Supported Instance Types] (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html) in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default - r5.large.elasticsearch
     * @experimental
     */
    readonly masterNodeInstanceType?: string;
    /**
     * (experimental) The number of data nodes (instances) to use in the Amazon ES domain.
     *
     * @default - 1
     * @experimental
     */
    readonly dataNodes?: number;
    /**
     * (experimental) The instance type for your data nodes, such as `m3.medium.elasticsearch`. For valid values, see [Supported Instance Types](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html) in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default - r5.large.elasticsearch
     * @experimental
     */
    readonly dataNodeInstanceType?: string;
    /**
     * (experimental) The number of UltraWarm nodes (instances) to use in the Amazon ES domain.
     *
     * @default - no UltraWarm nodes
     * @experimental
     */
    readonly warmNodes?: number;
    /**
     * (experimental) The instance type for your UltraWarm node, such as `ultrawarm1.medium.elasticsearch`. For valid values, see [UltraWarm Storage Limits] (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-limits.html#limits-ultrawarm) in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default - ultrawarm1.medium.elasticsearch
     * @experimental
     */
    readonly warmInstanceType?: string;
}
/**
 * (experimental) Specifies zone awareness configuration options.
 *
 * @experimental
 */
export interface ZoneAwarenessConfig {
    /**
     * (experimental) Indicates whether to enable zone awareness for the Amazon ES domain.
     *
     * When you enable zone awareness, Amazon ES allocates the nodes and replica
     * index shards that belong to a cluster across two Availability Zones (AZs)
     * in the same region to prevent data loss and minimize downtime in the event
     * of node or data center failure. Don't enable zone awareness if your cluster
     * has no replica index shards or is a single-node cluster. For more information,
     * see [Configuring a Multi-AZ Domain]
     * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-managedomains-multiaz)
     * in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default - false
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
     *
     * Valid values are 2 and 3.
     *
     * @default - 2 if zone awareness is enabled.
     * @experimental
     */
    readonly availabilityZoneCount?: number;
}
/**
 * (experimental) The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon ES domain.
 *
 * For more information, see
 * [Configuring EBS-based Storage]
 * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
 * in the Amazon Elasticsearch Service Developer Guide.
 *
 * @experimental
 */
export interface EbsOptions {
    /**
     * (experimental) Specifies whether Amazon EBS volumes are attached to data nodes in the Amazon ES domain.
     *
     * @default - true
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) The number of I/O operations per second (IOPS) that the volume supports.
     *
     * This property applies only to the Provisioned IOPS (SSD) EBS
     * volume type.
     *
     * @default - iops are not set.
     * @experimental
     */
    readonly iops?: number;
    /**
     * (experimental) The size (in GiB) of the EBS volume for each data node.
     *
     * The minimum and
     * maximum size of an EBS volume depends on the EBS volume type and the
     * instance type to which it is attached.  For more information, see
     * [Configuring EBS-based Storage]
     * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
     * in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default 10
     * @experimental
     */
    readonly volumeSize?: number;
    /**
     * (experimental) The EBS volume type to use with the Amazon ES domain, such as standard, gp2, io1.
     *
     * For more information, see[Configuring EBS-based Storage]
     * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
     * in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default gp2
     * @experimental
     */
    readonly volumeType?: ec2.EbsDeviceVolumeType;
}
/**
 * (experimental) Configures log settings for the domain.
 *
 * @experimental
 */
export interface LoggingOptions {
    /**
     * (experimental) Specify if slow search logging should be set up.
     *
     * Requires Elasticsearch version 5.1 or later.
     *
     * @default - false
     * @experimental
     */
    readonly slowSearchLogEnabled?: boolean;
    /**
     * (experimental) Log slow searches to this log group.
     *
     * @default - a new log group is created if slow search logging is enabled
     * @experimental
     */
    readonly slowSearchLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Specify if slow index logging should be set up.
     *
     * Requires Elasticsearch version 5.1 or later.
     *
     * @default - false
     * @experimental
     */
    readonly slowIndexLogEnabled?: boolean;
    /**
     * (experimental) Log slow indices to this log group.
     *
     * @default - a new log group is created if slow index logging is enabled
     * @experimental
     */
    readonly slowIndexLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Specify if Elasticsearch application logging should be set up.
     *
     * Requires Elasticsearch version 5.1 or later.
     *
     * @default - false
     * @experimental
     */
    readonly appLogEnabled?: boolean;
    /**
     * (experimental) Log Elasticsearch application logs to this log group.
     *
     * @default - a new log group is created if app logging is enabled
     * @experimental
     */
    readonly appLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Specify if Elasticsearch audit logging should be set up.
     *
     * Requires Elasticsearch version 6.7 or later and fine grained access control to be enabled.
     *
     * @default - false
     * @experimental
     */
    readonly auditLogEnabled?: boolean;
    /**
     * (experimental) Log Elasticsearch audit logs to this log group.
     *
     * @default - a new log group is created if audit logging is enabled
     * @experimental
     */
    readonly auditLogGroup?: logs.ILogGroup;
}
/**
 * (experimental) Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service (KMS) key to use.
 *
 * Can only be used to create a new domain,
 * not update an existing one. Requires Elasticsearch version 5.1 or later.
 *
 * @experimental
 */
export interface EncryptionAtRestOptions {
    /**
     * (experimental) Specify true to enable encryption at rest.
     *
     * @default - encryption at rest is disabled.
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) Supply if using KMS key for encryption at rest.
     *
     * @default - uses default aws/es KMS key.
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * (experimental) Configures Amazon ES to use Amazon Cognito authentication for Kibana.
 *
 * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html
 * @experimental
 */
export interface CognitoOptions {
    /**
     * (experimental) The Amazon Cognito identity pool ID that you want Amazon ES to use for Kibana authentication.
     *
     * @experimental
     */
    readonly identityPoolId: string;
    /**
     * (experimental) A role that allows Amazon ES to configure your user pool and identity pool.
     *
     * It must have the `AmazonESCognitoAccess` policy attached to it.
     *
     * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html#es-cognito-auth-prereq
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The Amazon Cognito user pool ID that you want Amazon ES to use for Kibana authentication.
     *
     * @experimental
     */
    readonly userPoolId: string;
}
/**
 * (experimental) The minimum TLS version required for traffic to the domain.
 *
 * @experimental
 */
export declare enum TLSSecurityPolicy {
    /**
     * (experimental) Cipher suite TLS 1.0.
     *
     * @experimental
     */
    TLS_1_0 = "Policy-Min-TLS-1-0-2019-07",
    /**
     * (experimental) Cipher suite TLS 1.2.
     *
     * @experimental
     */
    TLS_1_2 = "Policy-Min-TLS-1-2-2019-07"
}
/**
 * (experimental) Specifies options for fine-grained access control.
 *
 * @experimental
 */
export interface AdvancedSecurityOptions {
    /**
     * (experimental) ARN for the master user.
     *
     * Only specify this or masterUserName, but not both.
     *
     * @default - fine-grained access control is disabled
     * @experimental
     */
    readonly masterUserArn?: string;
    /**
     * (experimental) Username for the master user.
     *
     * Only specify this or masterUserArn, but not both.
     *
     * @default - fine-grained access control is disabled
     * @experimental
     */
    readonly masterUserName?: string;
    /**
     * (experimental) Password for the master user.
     *
     * You can use `SecretValue.plainText` to specify a password in plain text or
     * use `secretsmanager.Secret.fromSecretAttributes` to reference a secret in
     * Secrets Manager.
     *
     * @default - A Secrets Manager generated password
     * @experimental
     */
    readonly masterUserPassword?: cdk.SecretValue;
}
/**
 * (experimental) Configures a custom domain endpoint for the ES domain.
 *
 * @experimental
 */
export interface CustomEndpointOptions {
    /**
     * (experimental) The custom domain name to assign.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The certificate to use.
     *
     * @default - create a new one
     * @experimental
     */
    readonly certificate?: acm.ICertificate;
    /**
     * (experimental) The hosted zone in Route53 to create the CNAME record in.
     *
     * @default - do not create a CNAME
     * @experimental
     */
    readonly hostedZone?: route53.IHostedZone;
}
/**
 * (experimental) Properties for an AWS Elasticsearch Domain.
 *
 * @experimental
 */
export interface DomainProps {
    /**
     * (experimental) Domain Access policies.
     *
     * @default - No access policies.
     * @experimental
     */
    readonly accessPolicies?: iam.PolicyStatement[];
    /**
     * (experimental) Additional options to specify for the Amazon ES domain.
     *
     * @default - no advanced options are specified
     * @experimental
     */
    readonly advancedOptions?: {
        [key: string]: (string);
    };
    /**
     * (experimental) Configures Amazon ES to use Amazon Cognito authentication for Kibana.
     *
     * @default - Cognito not used for authentication to Kibana.
     * @experimental
     */
    readonly cognitoKibanaAuth?: CognitoOptions;
    /**
     * (experimental) Enforces a particular physical domain name.
     *
     * @default - A name will be auto-generated.
     * @experimental
     */
    readonly domainName?: string;
    /**
     * (experimental) The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon ES domain.
     *
     * For more information, see
     * [Configuring EBS-based Storage]
     * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
     * in the Amazon Elasticsearch Service Developer Guide.
     *
     * @default - 10 GiB General Purpose (SSD) volumes per node.
     * @experimental
     */
    readonly ebs?: EbsOptions;
    /**
     * (experimental) The cluster capacity configuration for the Amazon ES domain.
     *
     * @default - 1 r5.large.elasticsearch data node; no dedicated master nodes.
     * @experimental
     */
    readonly capacity?: CapacityConfig;
    /**
     * (experimental) The cluster zone awareness configuration for the Amazon ES domain.
     *
     * @default - no zone awareness (1 AZ)
     * @experimental
     */
    readonly zoneAwareness?: ZoneAwarenessConfig;
    /**
     * (experimental) The Elasticsearch version that your domain will leverage.
     *
     * @experimental
     */
    readonly version: ElasticsearchVersion;
    /**
     * (experimental) Encryption at rest options for the cluster.
     *
     * @default - No encryption at rest
     * @experimental
     */
    readonly encryptionAtRest?: EncryptionAtRestOptions;
    /**
     * (experimental) Configuration log publishing configuration options.
     *
     * @default - No logs are published
     * @experimental
     */
    readonly logging?: LoggingOptions;
    /**
     * (experimental) Specify true to enable node to node encryption.
     *
     * Requires Elasticsearch version 6.0 or later.
     *
     * @default - Node to node encryption is not enabled.
     * @experimental
     */
    readonly nodeToNodeEncryption?: boolean;
    /**
     * (experimental) The hour in UTC during which the service takes an automated daily snapshot of the indices in the Amazon ES domain.
     *
     * Only applies for Elasticsearch
     * versions below 5.3.
     *
     * @default - Hourly automated snapshots not used
     * @experimental
     */
    readonly automatedSnapshotStartHour?: number;
    /**
     * (experimental) Place the domain inside this VPC.
     *
     * @default - Domain is not placed in a VPC.
     * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The list of security groups that are associated with the VPC endpoints for the domain.
     *
     * Only used if `vpc` is specified.
     *
     * @default - One new security group is created.
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The specific vpc subnets the domain will be placed in.
     *
     * You must provide one subnet for each Availability Zone
     * that your domain uses. For example, you must specify three subnet IDs for a three Availability Zone
     * domain.
     *
     * Only used if `vpc` is specified.
     *
     * @default - All private subnets.
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection[];
    /**
     * (experimental) True to require that all traffic to the domain arrive over HTTPS.
     *
     * @default - false
     * @experimental
     */
    readonly enforceHttps?: boolean;
    /**
     * (experimental) The minimum TLS version required for traffic to the domain.
     *
     * @default - TLSSecurityPolicy.TLS_1_0
     * @experimental
     */
    readonly tlsSecurityPolicy?: TLSSecurityPolicy;
    /**
     * (experimental) Specifies options for fine-grained access control.
     *
     * Requires Elasticsearch version 6.7 or later. Enabling fine-grained access control
     * also requires encryption of data at rest and node-to-node encryption, along with
     * enforced HTTPS.
     *
     * @default - fine-grained access control is disabled
     * @experimental
     */
    readonly fineGrainedAccessControl?: AdvancedSecurityOptions;
    /**
     * (experimental) Configures the domain so that unsigned basic auth is enabled.
     *
     * If no master user is provided a default master user
     * with username `admin` and a dynamically generated password stored in KMS is created. The password can be retrieved
     * by getting `masterUserPassword` from the domain instance.
     *
     * Setting this to true will also add an access policy that allows unsigned
     * access, enable node to node encryption, encryption at rest. If conflicting
     * settings are encountered (like disabling encryption at rest) enabling this
     * setting will cause a failure.
     *
     * @default - false
     * @experimental
     */
    readonly useUnsignedBasicAuth?: boolean;
    /**
     * (experimental) To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire domain resource, use the EnableVersionUpgrade update policy.
     *
     * @default - false
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeelasticsearchdomain
     * @experimental
     */
    readonly enableVersionUpgrade?: boolean;
    /**
     * (experimental) Policy to apply when the domain is removed from the stack.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
    /**
     * (experimental) To configure a custom domain configure these options.
     *
     * If you specify a Route53 hosted zone it will create a CNAME record and use DNS validation for the certificate
     *
     * @default - no custom domain endpoint will be configured
     * @experimental
     */
    readonly customEndpoint?: CustomEndpointOptions;
}
/**
 * (experimental) An interface that represents an Elasticsearch domain - either created with the CDK, or an existing one.
 *
 * @experimental
 */
export interface IDomain extends cdk.IResource {
    /**
     * (experimental) Arn of the Elasticsearch domain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainArn: string;
    /**
     * (experimental) Domain name of the Elasticsearch domain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainName: string;
    /**
     * (experimental) Endpoint of the Elasticsearch domain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainEndpoint: string;
    /**
     * (experimental) Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantRead(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantReadWrite(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexRead(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexWrite(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexReadWrite(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathRead(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathWrite(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathReadWrite(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Domain.
     *
     * @experimental
     */
    metric(metricName: string, props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time the cluster status is red.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricClusterStatusRed(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time the cluster status is yellow.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricClusterStatusYellow(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the storage space of nodes in the cluster.
     *
     * @default minimum over 5 minutes
     * @experimental
     */
    metricFreeStorageSpace(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the cluster blocking index writes.
     *
     * @default maximum over 1 minute
     * @experimental
     */
    metricClusterIndexWritesBlocked(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the number of nodes.
     *
     * @default minimum over 1 hour
     * @experimental
     */
    metricNodes(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for automated snapshot failures.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricAutomatedSnapshotFailure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for CPU utilization.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricCPUUtilization(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricJVMMemoryPressure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for master CPU utilization.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricMasterCPUUtilization(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for master JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricMasterJVMMemoryPressure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for KMS key errors.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricKMSKeyError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for KMS key being inaccessible.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricKMSKeyInaccessible(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for number of searchable documents.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricSearchableDocuments(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for search latency.
     *
     * @default p99 over 5 minutes
     * @experimental
     */
    metricSearchLatency(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for indexing latency.
     *
     * @default p99 over 5 minutes
     * @experimental
     */
    metricIndexingLatency(props?: MetricOptions): Metric;
}
/**
 * A new or imported domain.
 */
declare abstract class DomainBase extends cdk.Resource implements IDomain {
    abstract readonly domainArn: string;
    abstract readonly domainName: string;
    abstract readonly domainEndpoint: string;
    /**
     * (experimental) Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantRead(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantReadWrite(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexRead(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexWrite(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
     *
     * @param index The index to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantIndexReadWrite(index: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathRead(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathWrite(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     *
     * @param path The path to grant permissions for.
     * @param identity The principal.
     * @experimental
     */
    grantPathReadWrite(path: string, identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Domain.
     *
     * @experimental
     */
    metric(metricName: string, props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time the cluster status is red.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricClusterStatusRed(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time the cluster status is yellow.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricClusterStatusYellow(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the storage space of nodes in the cluster.
     *
     * @default minimum over 5 minutes
     * @experimental
     */
    metricFreeStorageSpace(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the cluster blocking index writes.
     *
     * @default maximum over 1 minute
     * @experimental
     */
    metricClusterIndexWritesBlocked(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the number of nodes.
     *
     * @default minimum over 1 hour
     * @experimental
     */
    metricNodes(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for automated snapshot failures.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricAutomatedSnapshotFailure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for CPU utilization.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricCPUUtilization(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricJVMMemoryPressure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for master CPU utilization.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricMasterCPUUtilization(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for master JVM memory pressure.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricMasterJVMMemoryPressure(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for KMS key errors.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricKMSKeyError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for KMS key being inaccessible.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricKMSKeyInaccessible(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for number of searchable documents.
     *
     * @default maximum over 5 minutes
     * @experimental
     */
    metricSearchableDocuments(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for search latency.
     *
     * @default p99 over 5 minutes
     * @experimental
     */
    metricSearchLatency(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for indexing latency.
     *
     * @default p99 over 5 minutes
     * @experimental
     */
    metricIndexingLatency(props?: MetricOptions): Metric;
    private grant;
}
/**
 * (experimental) Reference to an Elasticsearch domain.
 *
 * @experimental
 */
export interface DomainAttributes {
    /**
     * (experimental) The ARN of the Elasticsearch domain.
     *
     * @experimental
     */
    readonly domainArn: string;
    /**
     * (experimental) The domain endpoint of the Elasticsearch domain.
     *
     * @experimental
     */
    readonly domainEndpoint: string;
}
/**
 * (experimental) Provides an Elasticsearch domain.
 *
 * @experimental
 */
export declare class Domain extends DomainBase implements IDomain, ec2.IConnectable {
    /**
     * (experimental) Creates a Domain construct that represents an external domain via domain endpoint.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param domainEndpoint The domain's endpoint.
     * @experimental
     */
    static fromDomainEndpoint(scope: Construct, id: string, domainEndpoint: string): IDomain;
    /**
     * (experimental) Creates a Domain construct that represents an external domain.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `DomainAttributes` object.
     * @experimental
     */
    static fromDomainAttributes(scope: Construct, id: string, attrs: DomainAttributes): IDomain;
    /**
     * (experimental) Arn of the Elasticsearch domain.
     *
     * @experimental
     */
    readonly domainArn: string;
    /**
     * (experimental) Domain name of the Elasticsearch domain.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) Endpoint of the Elasticsearch domain.
     *
     * @experimental
     */
    readonly domainEndpoint: string;
    /**
     * (experimental) Log group that slow searches are logged to.
     *
     * @experimental
     * @attribute true
     */
    readonly slowSearchLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Log group that slow indices are logged to.
     *
     * @experimental
     * @attribute true
     */
    readonly slowIndexLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Log group that application logs are logged to.
     *
     * @experimental
     * @attribute true
     */
    readonly appLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Log group that audit logs are logged to.
     *
     * @experimental
     * @attribute true
     */
    readonly auditLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Master user password if fine grained access control is configured.
     *
     * @experimental
     */
    readonly masterUserPassword?: cdk.SecretValue;
    private readonly domain;
    private readonly _connections;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainProps);
    /**
     * (experimental) Manages network connections to the domain.
     *
     * This will throw an error in case the domain
     * is not placed inside a VPC.
     *
     * @experimental
     */
    get connections(): ec2.Connections;
}
export {};
