"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTargetGroupBase = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Base internal class for existing target groups
 */
class ImportedTargetGroupBase extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Return an object to depend on the listeners added to this target group
         */
        this.loadBalancerAttached = new cdk.ConcreteDependable();
        this.targetGroupArn = props.targetGroupArn;
        this.loadBalancerArns = props.loadBalancerArns || cdk.Aws.NO_VALUE;
    }
}
exports.ImportedTargetGroupBase = ImportedTargetGroupBase;
//# sourceMappingURL=data:application/json;base64,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