import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { ITargetGroup, TargetGroupImportProps } from './base-target-group';
import { Construct as CoreConstruct } from "../../../core";
/**
 * Base internal class for existing target groups
 */
export declare abstract class ImportedTargetGroupBase extends CoreConstruct implements ITargetGroup {
    /**
     * ARN of the target group
     */
    readonly targetGroupArn: string;
    /**
     * A token representing a list of ARNs of the load balancers that route traffic to this target group
     */
    readonly loadBalancerArns: string;
    /**
     * Return an object to depend on the listeners added to this target group
     */
    readonly loadBalancerAttached: cdk.IDependable;
    constructor(scope: Construct, id: string, props: TargetGroupImportProps);
}
