"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.SslPolicy = exports.ApplicationProtocolVersion = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * (experimental) What kind of addresses to allocate to the load balancer.
 *
 * @experimental
 */
var IpAddressType;
(function (IpAddressType) {
    IpAddressType["IPV4"] = "ipv4";
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * (experimental) Backend protocol for network load balancers and health checks.
 *
 * @experimental
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "HTTP";
    Protocol["HTTPS"] = "HTTPS";
    Protocol["TCP"] = "TCP";
    Protocol["TLS"] = "TLS";
    Protocol["UDP"] = "UDP";
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * (experimental) Load balancing protocol for application load balancers.
 *
 * @experimental
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    ApplicationProtocol["HTTP"] = "HTTP";
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * (experimental) Load balancing protocol version for application load balancers.
 *
 * @experimental
 */
var ApplicationProtocolVersion;
(function (ApplicationProtocolVersion) {
    ApplicationProtocolVersion["GRPC"] = "GRPC";
    ApplicationProtocolVersion["HTTP1"] = "HTTP1";
    ApplicationProtocolVersion["HTTP2"] = "HTTP2";
})(ApplicationProtocolVersion = exports.ApplicationProtocolVersion || (exports.ApplicationProtocolVersion = {}));
/**
 * (experimental) Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @experimental
 */
var SslPolicy;
(function (SslPolicy) {
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    SslPolicy["FORWARD_SECRECY_TLS12_RES_GCM"] = "ELBSecurityPolicy-FS-1-2-Res-2020-10";
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * (experimental) How to interpret the load balancing target identifiers.
 *
 * @experimental
 */
var TargetType;
(function (TargetType) {
    TargetType["INSTANCE"] = "instance";
    TargetType["IP"] = "ip";
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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