import * as ec2 from "../../../aws-ec2";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { Protocol, TargetType } from './enums';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Basic properties of both Application and Network Target Groups.
 *
 * @experimental
 */
export interface BaseTargetGroupProps {
    /**
     * (experimental) The name of the target group.
     *
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     *
     * @default - Automatically generated.
     * @experimental
     */
    readonly targetGroupName?: string;
    /**
     * (experimental) The virtual private cloud (VPC).
     *
     * only if `TargetType` is `Ip` or `InstanceId`
     *
     * @default - undefined
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The amount of time for Elastic Load Balancing to wait before deregistering a target.
     *
     * The range is 0-3600 seconds.
     *
     * @default 300
     * @experimental
     */
    readonly deregistrationDelay?: cdk.Duration;
    /**
     * (experimental) Health check configuration.
     *
     * @default - None.
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) The type of targets registered to this TargetGroup, either IP or Instance.
     *
     * All targets registered into the group must be of this type. If you
     * register targets to the TargetGroup in the CDK app, the TargetType is
     * determined automatically.
     *
     * @default - Determined automatically.
     * @experimental
     */
    readonly targetType?: TargetType;
}
/**
 * (experimental) Properties for configuring a health check.
 *
 * @experimental
 */
export interface HealthCheck {
    /**
     * (experimental) Indicates whether health checks are enabled.
     *
     * If the target type is lambda,
     * health checks are disabled by default but can be enabled. If the target type
     * is instance or ip, health checks are always enabled and cannot be disabled.
     *
     * @default - Determined automatically.
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) The approximate number of seconds between health checks for an individual target.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly interval?: cdk.Duration;
    /**
     * (experimental) The ping path destination where Elastic Load Balancing sends health check requests.
     *
     * @default /
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The port that the load balancer uses when performing health checks on the targets.
     *
     * @default 'traffic-port'
     * @experimental
     */
    readonly port?: string;
    /**
     * (experimental) The protocol the load balancer uses when performing health checks on targets.
     *
     * The TCP protocol is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP.
     * The TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     *
     * @default HTTP for ALBs, TCP for NLBs
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) The amount of time, in seconds, during which no response from a target means a failed health check.
     *
     * For Application Load Balancers, the range is 2-60 seconds and the
     * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
     * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
     *
     * @default Duration.seconds(5) for ALBs, Duration.seconds(10) or Duration.seconds(6) for NLBs
     * @experimental
     */
    readonly timeout?: cdk.Duration;
    /**
     * (experimental) The number of consecutive health checks successes required before considering an unhealthy target healthy.
     *
     * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
     *
     * @default 5 for ALBs, 3 for NLBs
     * @experimental
     */
    readonly healthyThresholdCount?: number;
    /**
     * (experimental) The number of consecutive health check failures required before considering a target unhealthy.
     *
     * For Application Load Balancers, the default is 2. For Network Load
     * Balancers, this value must be the same as the healthy threshold count.
     *
     * @default 2
     * @experimental
     */
    readonly unhealthyThresholdCount?: number;
    /**
     * (experimental) GRPC code to use when checking for a successful response from a target.
     *
     * You can specify values between 0 and 99. You can specify multiple values
     * (for example, "0,1") or a range of values (for example, "0-5").
     *
     * @default - 12
     * @experimental
     */
    readonly healthyGrpcCodes?: string;
    /**
     * (experimental) HTTP code to use when checking for a successful response from a target.
     *
     * For Application Load Balancers, you can specify values between 200 and
     * 499, and the default value is 200. You can specify multiple values (for
     * example, "200,202") or a range of values (for example, "200-299").
     *
     * @experimental
     */
    readonly healthyHttpCodes?: string;
}
/**
 * (experimental) Define the target of a load balancer.
 *
 * @experimental
 */
export declare abstract class TargetGroupBase extends CoreConstruct implements ITargetGroup {
    /**
     * (experimental) The ARN of the target group.
     *
     * @experimental
     */
    readonly targetGroupArn: string;
    /**
     * (experimental) The full name of the target group.
     *
     * @experimental
     */
    readonly targetGroupFullName: string;
    /**
     * (experimental) The name of the target group.
     *
     * @experimental
     */
    readonly targetGroupName: string;
    /**
     * (experimental) ARNs of load balancers load balancing to this TargetGroup.
     *
     * @experimental
     */
    readonly targetGroupLoadBalancerArns: string[];
    /**
     * (experimental) Full name of first load balancer.
     *
     * This identifier is emitted as a dimensions of the metrics of this target
     * group.
     *
     * @experimental
     * @example
     *
     * app/my-load-balancer/123456789
     */
    abstract readonly firstLoadBalancerFullName: string;
    /**
     * (experimental) A token representing a list of ARNs of the load balancers that route traffic to this target group.
     *
     * @experimental
     */
    readonly loadBalancerArns: string;
    /**
     * @experimental
     */
    healthCheck: HealthCheck;
    /**
     * (experimental) Default port configured for members of this target group.
     *
     * @experimental
     */
    protected readonly defaultPort: number;
    /**
     * (experimental) Configurable dependable with all resources that lead to load balancer attachment.
     *
     * @experimental
     */
    protected readonly loadBalancerAttachedDependencies: cdk.ConcreteDependable;
    /**
     * (experimental) The types of the directly registered members of this target group.
     *
     * @experimental
     */
    protected targetType?: TargetType;
    /**
     * Attributes of this target group
     */
    private readonly attributes;
    /**
     * The JSON objects returned by the directly registered members of this target group
     */
    private readonly targetsJson;
    /**
     * The target group VPC
     *
     * @default - Required if adding instances instead of Lambdas to TargetGroup
     */
    private vpc?;
    /**
     * The target group resource
     */
    private readonly resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, baseProps: BaseTargetGroupProps, additionalProps: any);
    /**
     * (experimental) List of constructs that need to be depended on to ensure the TargetGroup is associated to a load balancer.
     *
     * @experimental
     */
    get loadBalancerAttached(): cdk.IDependable;
    /**
     * (experimental) Set/replace the target group's health check.
     *
     * @experimental
     */
    configureHealthCheck(healthCheck: HealthCheck): void;
    /**
     * (experimental) Set a non-standard attribute on the target group.
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     * @experimental
     */
    setAttribute(key: string, value: string | undefined): void;
    /**
     * (experimental) Register the given load balancing target as part of this group.
     *
     * @experimental
     */
    protected addLoadBalancerTarget(props: LoadBalancerTargetProps): void;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
}
/**
 * (experimental) Properties to reference an existing target group.
 *
 * @experimental
 */
export interface TargetGroupAttributes {
    /**
     * (experimental) ARN of the target group.
     *
     * @experimental
     */
    readonly targetGroupArn: string;
    /**
     * (deprecated) Port target group is listening on.
     *
     * @deprecated - This property is unused and the wrong type. No need to use it.
     */
    readonly defaultPort?: string;
    /**
     * (experimental) A Token representing the list of ARNs for the load balancer routing to this target group.
     *
     * @experimental
     */
    readonly loadBalancerArns?: string;
}
/**
 * (deprecated) Properties to reference an existing target group.
 *
 * @deprecated Use TargetGroupAttributes instead
 */
export interface TargetGroupImportProps extends TargetGroupAttributes {
}
/**
 * (experimental) A target group.
 *
 * @experimental
 */
export interface ITargetGroup extends cdk.IConstruct {
    /**
     * (experimental) ARN of the target group.
     *
     * @experimental
     */
    readonly targetGroupArn: string;
    /**
     * (experimental) A token representing a list of ARNs of the load balancers that route traffic to this target group.
     *
     * @experimental
     */
    readonly loadBalancerArns: string;
    /**
     * (experimental) Return an object to depend on the listeners added to this target group.
     *
     * @experimental
     */
    readonly loadBalancerAttached: cdk.IDependable;
}
/**
 * (experimental) Result of attaching a target to load balancer.
 *
 * @experimental
 */
export interface LoadBalancerTargetProps {
    /**
     * (experimental) What kind of target this is.
     *
     * @experimental
     */
    readonly targetType: TargetType;
    /**
     * (experimental) JSON representing the target's direct addition to the TargetGroup list.
     *
     * May be omitted if the target is going to register itself later.
     *
     * @experimental
     */
    readonly targetJson?: any;
}
/**
 * Extract the full load balancer name (used for metrics) from the listener ARN:
 *
 * Turns
 *
 *     arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2
 *
 * Into
 *
 *     app/my-load-balancer/50dc6c495c0c9188
 */
export declare function loadBalancerNameFromListenerArn(listenerArn: string): string;
