import * as ec2 from "../../../aws-ec2";
import * as s3 from "../../../aws-s3";
import * as cxschema from "../../../cloud-assembly-schema";
import { IResource, Resource } from "../../../core";
import * as cxapi from "../../../cx-api";
import { Construct } from 'constructs';
/**
 * (experimental) Shared properties of both Application and Network Load Balancers.
 *
 * @experimental
 */
export interface BaseLoadBalancerProps {
    /**
     * (experimental) Name of the load balancer.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly loadBalancerName?: string;
    /**
     * (experimental) The VPC network to place the load balancer in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Whether the load balancer has an internet-routable address.
     *
     * @default false
     * @experimental
     */
    readonly internetFacing?: boolean;
    /**
     * (experimental) Which subnets place the load balancer in.
     *
     * @default - the Vpc default strategy.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Indicates whether deletion protection is enabled.
     *
     * @default false
     * @experimental
     */
    readonly deletionProtection?: boolean;
}
/**
 * @experimental
 */
export interface ILoadBalancerV2 extends IResource {
    /**
     * (experimental) The canonical hosted zone ID of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * Z2P70J7EXAMPLE
     */
    readonly loadBalancerCanonicalHostedZoneId: string;
    /**
     * (experimental) The DNS name of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * my-load-balancer-424835706.us-west-2.elb.amazonaws.com
     */
    readonly loadBalancerDnsName: string;
}
/**
 * (experimental) Options for looking up load balancers.
 *
 * @experimental
 */
export interface BaseLoadBalancerLookupOptions {
    /**
     * (experimental) Find by load balancer's ARN.
     *
     * @default - does not search by load balancer arn
     * @experimental
     */
    readonly loadBalancerArn?: string;
    /**
     * (experimental) Match load balancer tags.
     *
     * @default - does not match load balancers by tags
     * @experimental
     */
    readonly loadBalancerTags?: Record<string, string>;
}
/**
 * Options for query context provider
 * @internal
 */
export interface LoadBalancerQueryContextProviderOptions {
    /**
     * User's lookup options
     */
    readonly userOptions: BaseLoadBalancerLookupOptions;
    /**
     * Type of load balancer
     */
    readonly loadBalancerType: cxschema.LoadBalancerType;
}
/**
 * (experimental) Base class for both Application and Network Load Balancers.
 *
 * @experimental
 */
export declare abstract class BaseLoadBalancer extends Resource {
    /**
     * Queries the load balancer context provider for load balancer info.
     * @internal
     */
    protected static _queryContextProvider(scope: Construct, options: LoadBalancerQueryContextProviderOptions): cxapi.LoadBalancerContextResponse;
    /**
     * (experimental) The canonical hosted zone ID of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * Z2P70J7EXAMPLE
     */
    readonly loadBalancerCanonicalHostedZoneId: string;
    /**
     * (experimental) The DNS name of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * my-load-balancer-424835706.us-west-2.elb.amazonaws.com
     */
    readonly loadBalancerDnsName: string;
    /**
     * (experimental) The full name of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * app/my-load-balancer/50dc6c495c0c9188
     */
    readonly loadBalancerFullName: string;
    /**
     * (experimental) The name of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * my-load-balancer
     */
    readonly loadBalancerName: string;
    /**
     * (experimental) The ARN of this load balancer.
     *
     * @experimental
     * @attribute true
     * @example
     *
     * arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-internal-load-balancer/50dc6c495c0c9188
     */
    readonly loadBalancerArn: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly loadBalancerSecurityGroups: string[];
    /**
     * (experimental) The VPC this load balancer has been created in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * Attributes set on this load balancer
     */
    private readonly attributes;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, baseProps: BaseLoadBalancerProps, additionalProps: any);
    /**
     * (experimental) Enable access logging for this load balancer.
     *
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     *
     * @experimental
     */
    logAccessLogs(bucket: s3.IBucket, prefix?: string): void;
    /**
     * (experimental) Set a non-standard attribute on the load balancer.
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes
     * @experimental
     */
    setAttribute(key: string, value: string | undefined): void;
    /**
     * (experimental) Remove an attribute from the load balancer.
     *
     * @experimental
     */
    removeAttribute(key: string): void;
}
