import * as cxschema from "../../../cloud-assembly-schema";
import { Resource } from "../../../core";
import * as cxapi from "../../../cx-api";
import { Construct } from 'constructs';
import { IListenerAction } from './listener-action';
/**
 * (experimental) Options for listener lookup.
 *
 * @experimental
 */
export interface BaseListenerLookupOptions {
    /**
     * (experimental) Filter listeners by associated load balancer arn.
     *
     * @default - does not filter by load balancer arn
     * @experimental
     */
    readonly loadBalancerArn?: string;
    /**
     * (experimental) Filter listeners by associated load balancer tags.
     *
     * @default - does not filter by load balancer tags
     * @experimental
     */
    readonly loadBalancerTags?: Record<string, string>;
    /**
     * (experimental) Filter listeners by listener port.
     *
     * @default - does not filter by listener port
     * @experimental
     */
    readonly listenerPort?: number;
}
/**
 * Options for querying the load balancer listener context provider
 * @internal
 */
export interface ListenerQueryContextProviderOptions {
    /**
     * User's provided options
     */
    readonly userOptions: BaseListenerLookupOptions;
    /**
     * Type of load balancer expected
     */
    readonly loadBalancerType: cxschema.LoadBalancerType;
    /**
     * ARN of the listener to look up
     * @default - does not filter by listener arn
     */
    readonly listenerArn?: string;
    /**
     * Optional protocol of the listener to look up
     */
    readonly listenerProtocol?: cxschema.LoadBalancerListenerProtocol;
}
/**
 * (experimental) Base class for listeners.
 *
 * @experimental
 */
export declare abstract class BaseListener extends Resource {
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    protected static _queryContextProvider(scope: Construct, options: ListenerQueryContextProviderOptions): cxapi.LoadBalancerListenerContextResponse;
    /**
     * @experimental
     * @attribute true
     */
    readonly listenerArn: string;
    private defaultAction?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, additionalProps: any);
    /**
     * (experimental) Validate this listener.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Configure the default action
     *
     * @internal
     */
    protected _setDefaultAction(action: IListenerAction): void;
}
