import { Duration, IResource } from "../../../core";
import { Construct } from 'constructs';
import { BaseListener, BaseListenerLookupOptions } from '../shared/base-listener';
import { HealthCheck } from '../shared/base-target-group';
import { Protocol, SslPolicy } from '../shared/enums';
import { IListenerCertificate } from '../shared/listener-certificate';
import { NetworkListenerAction } from './network-listener-action';
import { INetworkLoadBalancer } from './network-load-balancer';
import { INetworkLoadBalancerTarget, INetworkTargetGroup, NetworkTargetGroup } from './network-target-group';
/**
 * (experimental) Basic properties for a Network Listener.
 *
 * @experimental
 */
export interface BaseNetworkListenerProps {
    /**
     * (experimental) The port on which the listener listens for requests.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Default target groups to load balance to.
     *
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use
     * either `defaultAction` or `addAction()`.
     *
     * Cannot be specified together with `defaultAction`.
     *
     * @default - None.
     * @experimental
     */
    readonly defaultTargetGroups?: INetworkTargetGroup[];
    /**
     * (experimental) Default action to take for requests to this listener.
     *
     * This allows full control of the default Action of the load balancer,
     * including weighted forwarding. See the `NetworkListenerAction` class for
     * all options.
     *
     * Cannot be specified together with `defaultTargetGroups`.
     *
     * @default - None.
     * @experimental
     */
    readonly defaultAction?: NetworkListenerAction;
    /**
     * (experimental) Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP.
     *
     * @default - TLS if certificates are provided. TCP otherwise.
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) Certificate list of ACM cert ARNs.
     *
     * @default - No certificates.
     * @experimental
     */
    readonly certificates?: IListenerCertificate[];
    /**
     * (experimental) SSL Policy.
     *
     * @default - Current predefined security policy.
     * @experimental
     */
    readonly sslPolicy?: SslPolicy;
}
/**
 * (deprecated) Properties for adding a certificate to a listener.
 *
 * This interface exists for backwards compatibility.
 *
 * @deprecated Use IListenerCertificate instead
 */
export interface INetworkListenerCertificateProps extends IListenerCertificate {
}
/**
 * (experimental) Properties for a Network Listener attached to a Load Balancer.
 *
 * @experimental
 */
export interface NetworkListenerProps extends BaseNetworkListenerProps {
    /**
     * (experimental) The load balancer to attach this listener to.
     *
     * @experimental
     */
    readonly loadBalancer: INetworkLoadBalancer;
}
/**
 * (experimental) Options for looking up a network listener.
 *
 * @experimental
 */
export interface NetworkListenerLookupOptions extends BaseListenerLookupOptions {
    /**
     * (experimental) Protocol of the listener port.
     *
     * @default - listener is not filtered by protocol
     * @experimental
     */
    readonly listenerProtocol?: Protocol;
}
/**
 * (experimental) Define a Network Listener.
 *
 * @experimental
 * @resource AWS::ElasticLoadBalancingV2::Listener
 */
export declare class NetworkListener extends BaseListener implements INetworkListener {
    /**
     * (experimental) Looks up a network listener.
     *
     * @experimental
     */
    static fromLookup(scope: Construct, id: string, options: NetworkListenerLookupOptions): INetworkListener;
    /**
     * (experimental) Import an existing listener.
     *
     * @experimental
     */
    static fromNetworkListenerArn(scope: Construct, id: string, networkListenerArn: string): INetworkListener;
    /**
     * (experimental) The load balancer this listener is attached to.
     *
     * @experimental
     */
    readonly loadBalancer: INetworkLoadBalancer;
    /**
     * the protocol of the listener
     */
    private readonly protocol;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NetworkListenerProps);
    /**
     * (experimental) Load balance incoming requests to the given target groups.
     *
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use `addAction()`.
     *
     * @experimental
     */
    addTargetGroups(_id: string, ...targetGroups: INetworkTargetGroup[]): void;
    /**
     * (experimental) Perform the given Action on incoming requests.
     *
     * This allows full control of the default Action of the load balancer,
     * including weighted forwarding. See the `NetworkListenerAction` class for
     * all options.
     *
     * @experimental
     */
    addAction(_id: string, props: AddNetworkActionProps): void;
    /**
     * (experimental) Load balance incoming requests to the given load balancing targets.
     *
     * This method implicitly creates a NetworkTargetGroup for the targets
     * involved, and a 'forward' action to route traffic to the given TargetGroup.
     *
     * If you want more control over the precise setup, create the TargetGroup
     * and use `addAction` yourself.
     *
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     *
     * @returns The newly created target group
     * @experimental
     */
    addTargets(id: string, props: AddNetworkTargetsProps): NetworkTargetGroup;
    /**
     * Wrapper for _setDefaultAction which does a type-safe bind
     */
    private setDefaultAction;
}
/**
 * (experimental) Properties to reference an existing listener.
 *
 * @experimental
 */
export interface INetworkListener extends IResource {
    /**
     * (experimental) ARN of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerArn: string;
}
/**
 * (experimental) Properties for adding a new action to a listener.
 *
 * @experimental
 */
export interface AddNetworkActionProps {
    /**
     * (experimental) Action to perform.
     *
     * @experimental
     */
    readonly action: NetworkListenerAction;
}
/**
 * (experimental) Properties for adding new network targets to a listener.
 *
 * @experimental
 */
export interface AddNetworkTargetsProps {
    /**
     * (experimental) The port on which the listener listens for requests.
     *
     * @default Determined from protocol if known
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
     *
     * @default - inherits the protocol of the listener
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) The targets to add to this target group.
     *
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     *
     * @experimental
     */
    readonly targets?: INetworkLoadBalancerTarget[];
    /**
     * (experimental) The name of the target group.
     *
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     *
     * @default Automatically generated
     * @experimental
     */
    readonly targetGroupName?: string;
    /**
     * (experimental) The amount of time for Elastic Load Balancing to wait before deregistering a target.
     *
     * The range is 0-3600 seconds.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly deregistrationDelay?: Duration;
    /**
     * (experimental) Indicates whether Proxy Protocol version 2 is enabled.
     *
     * @default false
     * @experimental
     */
    readonly proxyProtocolV2?: boolean;
    /**
     * (experimental) Indicates whether client IP preservation is enabled.
     *
     * @default false if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, true.
     * @experimental
     */
    readonly preserveClientIp?: boolean;
    /**
     * (experimental) Health check configuration.
     *
     * @default No health check
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
}
