"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkELBMetrics = exports.ApplicationELBMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ApplicationELBMetrics {
    static requestCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb5XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_5XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static activeConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ActiveConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static clientTlsNegotiationErrorCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ClientTLSNegotiationErrorCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedLcUsAverage(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ConsumedLCUs',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpFixedResponseCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Fixed_Response_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpRedirectCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Redirect_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpRedirectUrlLimitExceededCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Redirect_Url_Limit_Exceeded_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb3XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_3XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb4XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_4XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static iPv6ProcessedBytesSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'IPv6ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static iPv6RequestCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'IPv6RequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static newConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'NewConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static processedBytesSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static rejectedConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RejectedConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static ruleEvaluationsSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RuleEvaluations',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.ApplicationELBMetrics = ApplicationELBMetrics;
class NetworkELBMetrics {
    static healthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'HealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static unHealthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'UnHealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static activeFlowCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ActiveFlowCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedLcUsAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ConsumedLCUs',
            dimensions,
            statistic: 'Average',
        };
    }
    static newFlowCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'NewFlowCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static processedBytesSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpClientResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_Client_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpElbResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_ELB_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpTargetResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_Target_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NetworkELBMetrics = NetworkELBMetrics;
//# sourceMappingURL=data:application/json;base64,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