import * as cloudwatch from "../../../aws-cloudwatch";
import * as ec2 from "../../../aws-ec2";
import { Duration } from "../../../core";
import { Construct } from 'constructs';
import { BaseLoadBalancer, BaseLoadBalancerLookupOptions, BaseLoadBalancerProps, ILoadBalancerV2 } from '../shared/base-load-balancer';
import { IpAddressType, ApplicationProtocol } from '../shared/enums';
import { ApplicationListener, BaseApplicationListenerProps } from './application-listener';
/**
 * (experimental) Properties for defining an Application Load Balancer.
 *
 * @experimental
 */
export interface ApplicationLoadBalancerProps extends BaseLoadBalancerProps {
    /**
     * (experimental) Security group to associate with this load balancer.
     *
     * @default A security group is created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The type of IP addresses to use.
     *
     * Only applies to application load balancers.
     *
     * @default IpAddressType.Ipv4
     * @experimental
     */
    readonly ipAddressType?: IpAddressType;
    /**
     * (experimental) Indicates whether HTTP/2 is enabled.
     *
     * @default true
     * @experimental
     */
    readonly http2Enabled?: boolean;
    /**
     * (experimental) The load balancer idle timeout, in seconds.
     *
     * @default 60
     * @experimental
     */
    readonly idleTimeout?: Duration;
}
/**
 * (experimental) Options for looking up an ApplicationLoadBalancer.
 *
 * @experimental
 */
export interface ApplicationLoadBalancerLookupOptions extends BaseLoadBalancerLookupOptions {
}
/**
 * (experimental) Define an Application Load Balancer.
 *
 * @experimental
 * @resource AWS::ElasticLoadBalancingV2::LoadBalancer
 */
export declare class ApplicationLoadBalancer extends BaseLoadBalancer implements IApplicationLoadBalancer {
    /**
     * (experimental) Look up an application load balancer.
     *
     * @experimental
     */
    static fromLookup(scope: Construct, id: string, options: ApplicationLoadBalancerLookupOptions): IApplicationLoadBalancer;
    /**
     * (experimental) Import an existing Application Load Balancer.
     *
     * @experimental
     */
    static fromApplicationLoadBalancerAttributes(scope: Construct, id: string, attrs: ApplicationLoadBalancerAttributes): IApplicationLoadBalancer;
    /**
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The IP Address Type for this load balancer.
     *
     * @experimental
     */
    readonly ipAddressType?: IpAddressType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationLoadBalancerProps);
    /**
     * (experimental) Add a new listener to this load balancer.
     *
     * @experimental
     */
    addListener(id: string, props: BaseApplicationListenerProps): ApplicationListener;
    /**
     * (experimental) Add a redirection listener to this load balancer.
     *
     * @experimental
     */
    addRedirect(props?: ApplicationLoadBalancerRedirectConfig): ApplicationListener;
    /**
     * (experimental) Add a security group to this load balancer.
     *
     * @experimental
     */
    addSecurityGroup(securityGroup: ec2.ISecurityGroup): void;
    /**
     * (experimental) Return the given named metric for this Application Load Balancer.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricActiveConnectionCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     *
     * Possible causes include a
     * mismatch of ciphers or protocols.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricClientTlsNegotiationErrorCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of load balancer capacity units (LCU) used by your load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricConsumedLCUs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of fixed-response actions that were successful.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricHttpFixedResponseCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of redirect actions that were successful.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricHttpRedirectCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricHttpRedirectUrlLimitExceededCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     *
     * This does not include any response codes generated by the targets.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricHttpCodeElb(code: HttpCodeElb, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     *
     * This does not include any response codes generated by the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricHttpCodeTarget(code: HttpCodeTarget, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of bytes processed by the load balancer over IPv6.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricIpv6ProcessedBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of IPv6 requests received by the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricIpv6RequestCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricNewConnectionCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of bytes processed by the load balancer over IPv4 and IPv6.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricProcessedBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricRejectedConnectionCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of requests processed over IPv4 and IPv6.
     *
     * This count includes only the requests with a response generated by a target of the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricRequestCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of rules processed by the load balancer given a request rate averaged over an hour.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricRuleEvaluations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of connections that were not successfully established between the load balancer and target.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricTargetConnectionErrorCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricTargetResponseTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     *
     * Possible causes include a mismatch of ciphers or protocols.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricTargetTLSNegotiationErrorCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of user authentications that could not be completed.
     *
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricElbAuthError(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricElbAuthFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     *
     * If one or more of these operations fail, this is the time to failure.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricElbAuthLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of authenticate actions that were successful.
     *
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricElbAuthSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private cannedMetric;
}
/**
 * (experimental) Count of HTTP status originating from the load balancer.
 *
 * This count does not include any response codes generated by the targets.
 *
 * @experimental
 */
export declare enum HttpCodeElb {
    /**
     * (experimental) The number of HTTP 3XX redirection codes that originate from the load balancer.
     *
     * @experimental
     */
    ELB_3XX_COUNT = "HTTPCode_ELB_3XX_Count",
    /**
     * (experimental) The number of HTTP 4XX client error codes that originate from the load balancer.
     *
     * Client errors are generated when requests are malformed or incomplete.
     * These requests have not been received by the target. This count does not
     * include any response codes generated by the targets.
     *
     * @experimental
     */
    ELB_4XX_COUNT = "HTTPCode_ELB_4XX_Count",
    /**
     * (experimental) The number of HTTP 5XX server error codes that originate from the load balancer.
     *
     * @experimental
     */
    ELB_5XX_COUNT = "HTTPCode_ELB_5XX_Count"
}
/**
 * (experimental) Count of HTTP status originating from the targets.
 *
 * @experimental
 */
export declare enum HttpCodeTarget {
    /**
     * (experimental) The number of 2xx response codes from targets.
     *
     * @experimental
     */
    TARGET_2XX_COUNT = "HTTPCode_Target_2XX_Count",
    /**
     * (experimental) The number of 3xx response codes from targets.
     *
     * @experimental
     */
    TARGET_3XX_COUNT = "HTTPCode_Target_3XX_Count",
    /**
     * (experimental) The number of 4xx response codes from targets.
     *
     * @experimental
     */
    TARGET_4XX_COUNT = "HTTPCode_Target_4XX_Count",
    /**
     * (experimental) The number of 5xx response codes from targets.
     *
     * @experimental
     */
    TARGET_5XX_COUNT = "HTTPCode_Target_5XX_Count"
}
/**
 * (experimental) An application load balancer.
 *
 * @experimental
 */
export interface IApplicationLoadBalancer extends ILoadBalancerV2, ec2.IConnectable {
    /**
     * (experimental) The ARN of this load balancer.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
    /**
     * (experimental) The VPC this load balancer has been created in (if available).
     *
     * If this interface is the result of an import call to fromApplicationLoadBalancerAttributes,
     * the vpc attribute will be undefined unless specified in the optional properties of that method.
     *
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The IP Address Type for this load balancer.
     *
     * @default IpAddressType.IPV4
     * @experimental
     */
    readonly ipAddressType?: IpAddressType;
    /**
     * (experimental) Add a new listener to this load balancer.
     *
     * @experimental
     */
    addListener(id: string, props: BaseApplicationListenerProps): ApplicationListener;
}
/**
 * (experimental) Properties to reference an existing load balancer.
 *
 * @experimental
 */
export interface ApplicationLoadBalancerAttributes {
    /**
     * (experimental) ARN of the load balancer.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
    /**
     * (experimental) ID of the load balancer's security group.
     *
     * @experimental
     */
    readonly securityGroupId: string;
    /**
     * (experimental) The canonical hosted zone ID of this load balancer.
     *
     * @default - When not provided, LB cannot be used as Route53 Alias target.
     * @experimental
     */
    readonly loadBalancerCanonicalHostedZoneId?: string;
    /**
     * (experimental) The DNS name of this load balancer.
     *
     * @default - When not provided, LB cannot be used as Route53 Alias target.
     * @experimental
     */
    readonly loadBalancerDnsName?: string;
    /**
     * (experimental) Whether the security group allows all outbound traffic or not.
     *
     * Unless set to `false`, no egress rules will be added to the security group.
     *
     * @default true
     * @experimental
     */
    readonly securityGroupAllowsAllOutbound?: boolean;
    /**
     * (experimental) The VPC this load balancer has been created in, if available.
     *
     * @default - If the Load Balancer was imported and a VPC was not specified,
     * the VPC is not available.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * (experimental) Properties for a redirection config.
 *
 * @experimental
 */
export interface ApplicationLoadBalancerRedirectConfig {
    /**
     * (experimental) The protocol of the listener being created.
     *
     * @default HTTP
     * @experimental
     */
    readonly sourceProtocol?: ApplicationProtocol;
    /**
     * (experimental) The port number to listen to.
     *
     * @default 80
     * @experimental
     */
    readonly sourcePort?: number;
    /**
     * (experimental) The protocol of the redirection target.
     *
     * @default HTTPS
     * @experimental
     */
    readonly targetProtocol?: ApplicationProtocol;
    /**
     * (experimental) The port number to redirect to.
     *
     * @default 443
     * @experimental
     */
    readonly targetPort?: number;
    /**
     * (experimental) Allow anyone to connect to this listener.
     *
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     *
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     *
     * @default true
     * @experimental
     */
    readonly open?: boolean;
}
