import { Construct } from 'constructs';
import { IApplicationListener } from './application-listener';
import { ListenerAction } from './application-listener-action';
import { IApplicationTargetGroup } from './application-target-group';
import { ListenerCondition } from './conditions';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Basic properties for defining a rule on a listener.
 *
 * @experimental
 */
export interface BaseApplicationListenerRuleProps {
    /**
     * (experimental) Priority of the rule.
     *
     * The rule with the lowest priority will be used for every request.
     *
     * Priorities must be unique.
     *
     * @experimental
     */
    readonly priority: number;
    /**
     * (experimental) Target groups to forward requests to.
     *
     * Only one of `action`, `fixedResponse`, `redirectResponse` or `targetGroups` can be specified.
     *
     * Implies a `forward` action.
     *
     * @default - No target groups.
     * @experimental
     */
    readonly targetGroups?: IApplicationTargetGroup[];
    /**
     * (experimental) Action to perform when requests are received.
     *
     * Only one of `action`, `fixedResponse`, `redirectResponse` or `targetGroups` can be specified.
     *
     * @default - No action
     * @experimental
     */
    readonly action?: ListenerAction;
    /**
     * (deprecated) Fixed response to return.
     *
     * Only one of `action`, `fixedResponse`, `redirectResponse` or `targetGroups` can be specified.
     *
     * @default - No fixed response.
     * @deprecated Use `action` instead.
     */
    readonly fixedResponse?: FixedResponse;
    /**
     * (deprecated) Redirect response to return.
     *
     * Only one of `action`, `fixedResponse`, `redirectResponse` or `targetGroups` can be specified.
     *
     * @default - No redirect response.
     * @deprecated Use `action` instead.
     */
    readonly redirectResponse?: RedirectResponse;
    /**
     * (experimental) Rule applies if matches the conditions.
     *
     * @default - No conditions.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
     * @experimental
     */
    readonly conditions?: ListenerCondition[];
    /**
     * (deprecated) Rule applies if the requested host matches the indicated host.
     *
     * May contain up to three '*' wildcards.
     *
     * @default - No host condition.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly hostHeader?: string;
    /**
     * (deprecated) Rule applies if the requested path matches the given path pattern.
     *
     * @default - No path condition.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly pathPattern?: string;
    /**
     * (deprecated) Rule applies if the requested path matches any of the given patterns.
     *
     * Paths may contain up to three '*' wildcards.
     *
     * @default - No path conditions.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly pathPatterns?: string[];
}
/**
 * (experimental) Properties for defining a listener rule.
 *
 * @experimental
 */
export interface ApplicationListenerRuleProps extends BaseApplicationListenerRuleProps {
    /**
     * (experimental) The listener to attach the rule to.
     *
     * @experimental
     */
    readonly listener: IApplicationListener;
}
/**
 * (deprecated) The content type for a fixed response.
 *
 * @deprecated superceded by `FixedResponseOptions`.
 */
export declare enum ContentType {
    /**
     * @deprecated
     */
    TEXT_PLAIN = "text/plain",
    /**
     * @deprecated
     */
    TEXT_CSS = "text/css",
    /**
     * @deprecated
     */
    TEXT_HTML = "text/html",
    /**
     * @deprecated
     */
    APPLICATION_JAVASCRIPT = "application/javascript",
    /**
     * @deprecated
     */
    APPLICATION_JSON = "application/json"
}
/**
 * (deprecated) A fixed response.
 *
 * @deprecated superceded by `ListenerAction.fixedResponse()`.
 */
export interface FixedResponse {
    /**
     * (deprecated) The HTTP response code (2XX, 4XX or 5XX).
     *
     * @deprecated
     */
    readonly statusCode: string;
    /**
     * (deprecated) The content type.
     *
     * @default text/plain
     * @deprecated
     */
    readonly contentType?: ContentType;
    /**
     * (deprecated) The message.
     *
     * @default no message
     * @deprecated
     */
    readonly messageBody?: string;
}
/**
 * (deprecated) A redirect response.
 *
 * @deprecated superceded by `ListenerAction.redirect()`.
 */
export interface RedirectResponse {
    /**
     * (deprecated) The hostname.
     *
     * This component is not percent-encoded. The hostname can contain #{host}.
     *
     * @default origin host of request
     * @deprecated
     */
    readonly host?: string;
    /**
     * (deprecated) The absolute path, starting with the leading "/".
     *
     * This component is not percent-encoded.
     * The path can contain #{host}, #{path}, and #{port}.
     *
     * @default origin path of request
     * @deprecated
     */
    readonly path?: string;
    /**
     * (deprecated) The port.
     *
     * You can specify a value from 1 to 65535 or #{port}.
     *
     * @default origin port of request
     * @deprecated
     */
    readonly port?: string;
    /**
     * (deprecated) The protocol.
     *
     * You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP,
     * HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     *
     * @default origin protocol of request
     * @deprecated
     */
    readonly protocol?: string;
    /**
     * (deprecated) The query parameters, URL-encoded when necessary, but not percent-encoded.
     *
     * Do not include the leading "?", as it is automatically added.
     * You can specify any of the reserved keywords.
     *
     * @default origin query string of request
     * @deprecated
     */
    readonly query?: string;
    /**
     * (deprecated) The HTTP redirect code (HTTP_301 or HTTP_302).
     *
     * @deprecated
     */
    readonly statusCode: string;
}
/**
 * (experimental) Define a new listener rule.
 *
 * @experimental
 */
export declare class ApplicationListenerRule extends CoreConstruct {
    /**
     * (experimental) The ARN of this rule.
     *
     * @experimental
     */
    readonly listenerRuleArn: string;
    private readonly conditions;
    private readonly legacyConditions;
    private readonly listener;
    private action?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationListenerRuleProps);
    /**
     * (deprecated) Add a non-standard condition to this rule.
     *
     * If the condition conflicts with an already set condition, it will be overwritten by the one you specified.
     *
     * @deprecated use `addCondition` instead.
     */
    setCondition(field: string, values: string[] | undefined): void;
    /**
     * (experimental) Add a non-standard condition to this rule.
     *
     * @experimental
     */
    addCondition(condition: ListenerCondition): void;
    /**
     * (experimental) Configure the action to perform for this rule.
     *
     * @experimental
     */
    configureAction(action: ListenerAction): void;
    /**
     * (deprecated) Add a TargetGroup to load balance to.
     *
     * @deprecated Use configureAction instead
     */
    addTargetGroup(targetGroup: IApplicationTargetGroup): void;
    /**
     * (deprecated) Add a fixed response.
     *
     * @deprecated Use configureAction instead
     */
    addFixedResponse(fixedResponse: FixedResponse): void;
    /**
     * (deprecated) Add a redirect response.
     *
     * @deprecated Use configureAction instead
     */
    addRedirectResponse(redirectResponse: RedirectResponse): void;
    /**
     * (experimental) Validate the rule.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Render the conditions for this rule
     */
    private renderConditions;
}
/**
 * Validate the status code and message body of a fixed response
 * @internal
 * @deprecated
 */
export declare function validateFixedResponse(fixedResponse: FixedResponse): void;
/**
 * Validate the status code and message body of a redirect response
 * @internal
 * @deprecated
 */
export declare function validateRedirectResponse(redirectResponse: RedirectResponse): void;
