"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceTarget = exports.InstanceIdTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * (experimental) An EC2 instance that is the target for load balancing.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 *
 * @experimental
 */
class InstanceIdTarget {
    /**
     * (experimental) Create a new Instance target.
     *
     * @param instanceId Instance ID of the instance to register to.
     * @param port Override the default port for the target group.
     * @experimental
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * (experimental) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @experimental
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * (experimental) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @experimental
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
_a = JSII_RTTI_SYMBOL_1;
InstanceIdTarget[_a] = { fqn: "monocdk.aws_elasticloadbalancingv2_targets.InstanceIdTarget", version: "1.106.1" };
/**
 * @experimental
 */
class InstanceTarget extends InstanceIdTarget {
    /**
     * (experimental) Create a new Instance target.
     *
     * @param instance Instance to register to.
     * @param port Override the default port for the target group.
     * @experimental
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
_b = JSII_RTTI_SYMBOL_1;
InstanceTarget[_b] = { fqn: "monocdk.aws_elasticloadbalancingv2_targets.InstanceTarget", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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