"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * (experimental) A Listener Action to authenticate with Cognito.
 *
 * @experimental
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * (experimental) Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @experimental
     */
    constructor(options) {
        var _b;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_b = options.sessionTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds().toString(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
_a = JSII_RTTI_SYMBOL_1;
AuthenticateCognitoAction[_a] = { fqn: "monocdk.aws_elasticloadbalancingv2_actions.AuthenticateCognitoAction", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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