"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ELBMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ELBMetrics {
    static latencyAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static backendConnectionErrorsAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'BackendConnectionErrors',
            dimensions,
            statistic: 'Average',
        };
    }
    static requestCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'RequestCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static spilloverCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SpilloverCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static surgeQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SurgeQueueLength',
            dimensions,
            statistic: 'Average',
        };
    }
    static healthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static unHealthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'UnHealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend2XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_2XX',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend3XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_3XX',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend4XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_4XX',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend5XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_5XX',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.ELBMetrics = ELBMetrics;
//# sourceMappingURL=data:application/json;base64,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