import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export interface CfnApplicationProps {
    /**
     * `AWS::ElasticBeanstalk::Application.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-name
     */
    readonly applicationName?: string;
    /**
     * `AWS::ElasticBeanstalk::Application.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-description
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::Application.ResourceLifecycleConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-resourcelifecycleconfig
     */
    readonly resourceLifecycleConfig?: CfnApplication.ApplicationResourceLifecycleConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::Application";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * `AWS::ElasticBeanstalk::Application.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-name
     */
    applicationName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Application.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-description
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Application.ResourceLifecycleConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-resourcelifecycleconfig
     */
    resourceLifecycleConfig: CfnApplication.ApplicationResourceLifecycleConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html
     */
    interface ApplicationResourceLifecycleConfigProperty {
        /**
         * `CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        readonly serviceRole?: string;
        /**
         * `CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        readonly versionLifecycleConfig?: CfnApplication.ApplicationVersionLifecycleConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html
     */
    interface ApplicationVersionLifecycleConfigProperty {
        /**
         * `CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        readonly maxAgeRule?: CfnApplication.MaxAgeRuleProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        readonly maxCountRule?: CfnApplication.MaxCountRuleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html
     */
    interface MaxAgeRuleProperty {
        /**
         * `CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        readonly deleteSourceFromS3?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxAgeRuleProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxAgeRuleProperty.MaxAgeInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        readonly maxAgeInDays?: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html
     */
    interface MaxCountRuleProperty {
        /**
         * `CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        readonly deleteSourceFromS3?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxCountRuleProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxCountRuleProperty.MaxCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        readonly maxCount?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
export interface CfnApplicationVersionProps {
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    readonly sourceBundle: CfnApplicationVersion.SourceBundleProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ApplicationVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
export declare class CfnApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::ApplicationVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationVersion;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    sourceBundle: CfnApplicationVersion.SourceBundleProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::ApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ApplicationVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
export declare namespace CfnApplicationVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     */
    interface SourceBundleProperty {
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
export interface CfnConfigurationTemplateProps {
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    readonly environmentId?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    readonly optionSettings?: Array<CfnConfigurationTemplate.ConfigurationOptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    readonly platformArn?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    readonly solutionStackName?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    readonly sourceConfiguration?: CfnConfigurationTemplate.SourceConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
export declare class CfnConfigurationTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::ConfigurationTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationTemplate;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    environmentId: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    optionSettings: Array<CfnConfigurationTemplate.ConfigurationOptionSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    platformArn: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    solutionStackName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    sourceConfiguration: CfnConfigurationTemplate.SourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
export declare namespace CfnConfigurationTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    interface ConfigurationOptionSettingProperty {
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        readonly namespace: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        readonly optionName: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        readonly resourceName?: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
export declare namespace CfnConfigurationTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    interface SourceConfigurationProperty {
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        readonly applicationName: string;
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        readonly templateName: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::Environment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    readonly cnamePrefix?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    readonly environmentName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.OperationsRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-operations-role
     */
    readonly operationsRole?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    readonly optionSettings?: Array<CfnEnvironment.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    readonly platformArn?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    readonly solutionStackName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    readonly templateName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    readonly tier?: CfnEnvironment.TierProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    readonly versionLabel?: string;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::Environment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironment;
    /**
     * @external
     * @cloudformationAttribute EndpointURL
     */
    readonly attrEndpointUrl: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    cnamePrefix: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    environmentName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.OperationsRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-operations-role
     */
    operationsRole: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    optionSettings: Array<CfnEnvironment.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    platformArn: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    solutionStackName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    templateName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    tier: CfnEnvironment.TierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    versionLabel: string | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html
     */
    interface OptionSettingProperty {
        /**
         * `CfnEnvironment.OptionSettingProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        readonly namespace: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.OptionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        readonly optionName: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.ResourceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        readonly resourceName?: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html
     */
    interface TierProperty {
        /**
         * `CfnEnvironment.TierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        readonly name?: string;
        /**
         * `CfnEnvironment.TierProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        readonly type?: string;
        /**
         * `CfnEnvironment.TierProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        readonly version?: string;
    }
}
