"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ElastiCacheMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static freeableMemoryAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'FreeableMemory',
            dimensions,
            statistic: 'Average',
        };
    }
    static swapUsageAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'SwapUsage',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkBytesInAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'NetworkBytesIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkBytesOutAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'NetworkBytesOut',
            dimensions,
            statistic: 'Average',
        };
    }
    static currConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CurrConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static evictionsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'Evictions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static reclaimedSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'Reclaimed',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static replicationBytesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'ReplicationBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static replicationLagAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'ReplicationLag',
            dimensions,
            statistic: 'Average',
        };
    }
    static bytesUsedForCacheSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'BytesUsedForCache',
            dimensions,
            statistic: 'Sum',
        };
    }
    static currItemsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CurrItems',
            dimensions,
            statistic: 'Sum',
        };
    }
    static casHitsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CasHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static casMissesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CasMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static globalDatastoreReplicationLagAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'GlobalDatastoreReplicationLag',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.ElastiCacheMetrics = ElastiCacheMetrics;
//# sourceMappingURL=data:application/json;base64,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