"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderBottlerocketUserData = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// eslint-disable-next-line max-len
function renderAmazonLinuxUserData(cluster, autoScalingGroup, options = {}) {
    var _a;
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--apiserver-endpoint '${cluster.clusterEndpoint}'`);
    extraArgs.push(`--b64-cluster-ca '${cluster.clusterCertificateAuthorityData}'`);
    extraArgs.push(`--use-max-pods ${(_a = options.useMaxPods) !== null && _a !== void 0 ? _a : true}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge true');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.dnsClusterIp) {
        extraArgs.push(`--dns-cluster-ip ${options.dnsClusterIp}`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${cluster.clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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