import { InstanceType, ISecurityGroup, SubnetSelection } from "../../aws-ec2";
import { IRole } from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { ICluster } from './cluster';
/**
 * (experimental) NodeGroup interface.
 *
 * @experimental
 */
export interface INodegroup extends IResource {
    /**
     * (experimental) Name of the nodegroup.
     *
     * @experimental
     * @attribute true
     */
    readonly nodegroupName: string;
}
/**
 * (experimental) The AMI type for your node group.
 *
 * GPU instance types should use the `AL2_x86_64_GPU` AMI type, which uses the
 * Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the `AL2_x86_64` AMI type, which
 * uses the Amazon EKS-optimized Linux AMI.
 *
 * @experimental
 */
export declare enum NodegroupAmiType {
    /**
     * (experimental) Amazon Linux 2 (x86-64).
     *
     * @experimental
     */
    AL2_X86_64 = "AL2_x86_64",
    /**
     * (experimental) Amazon Linux 2 with GPU support.
     *
     * @experimental
     */
    AL2_X86_64_GPU = "AL2_x86_64_GPU",
    /**
     * (experimental) Amazon Linux 2 (ARM-64).
     *
     * @experimental
     */
    AL2_ARM_64 = "AL2_ARM_64"
}
/**
 * (experimental) Capacity type of the managed node group.
 *
 * @experimental
 */
export declare enum CapacityType {
    /**
     * (experimental) spot instances.
     *
     * @experimental
     */
    SPOT = "SPOT",
    /**
     * (experimental) on-demand instances.
     *
     * @experimental
     */
    ON_DEMAND = "ON_DEMAND"
}
/**
 * (experimental) The remote access (SSH) configuration to use with your node group.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html
 * @experimental
 */
export interface NodegroupRemoteAccess {
    /**
     * (experimental) The Amazon EC2 SSH key that provides access for SSH communication with the worker nodes in the managed node group.
     *
     * @experimental
     */
    readonly sshKeyName: string;
    /**
     * (experimental) The security groups that are allowed SSH access (port 22) to the worker nodes.
     *
     * If you specify an Amazon EC2 SSH
     * key but do not specify a source security group when you create a managed node group, then port 22 on the worker
     * nodes is opened to the internet (0.0.0.0/0).
     *
     * @default - port 22 on the worker nodes is opened to the internet (0.0.0.0/0)
     * @experimental
     */
    readonly sourceSecurityGroups?: ISecurityGroup[];
}
/**
 * (experimental) Launch template property specification.
 *
 * @experimental
 */
export interface LaunchTemplateSpec {
    /**
     * (experimental) The Launch template ID.
     *
     * @experimental
     */
    readonly id: string;
    /**
     * (experimental) The launch template version to be used (optional).
     *
     * @default - the default version of the launch template
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) The Nodegroup Options for addNodeGroup() method.
 *
 * @experimental
 */
export interface NodegroupOptions {
    /**
     * (experimental) Name of the Nodegroup.
     *
     * @default - resource ID
     * @experimental
     */
    readonly nodegroupName?: string;
    /**
     * (experimental) The subnets to use for the Auto Scaling group that is created for your node group.
     *
     * By specifying the
     * SubnetSelection, the selected subnets will automatically apply required tags i.e.
     * `kubernetes.io/cluster/CLUSTER_NAME` with a value of `shared`, where `CLUSTER_NAME` is replaced with
     * the name of your cluster.
     *
     * @default - private subnets
     * @experimental
     */
    readonly subnets?: SubnetSelection;
    /**
     * (experimental) The AMI type for your node group.
     *
     * @default - auto-determined from the instanceTypes property.
     * @experimental
     */
    readonly amiType?: NodegroupAmiType;
    /**
     * (experimental) The root device disk size (in GiB) for your node group instances.
     *
     * @default 20
     * @experimental
     */
    readonly diskSize?: number;
    /**
     * (experimental) The current number of worker nodes that the managed node group should maintain.
     *
     * If not specified,
     * the nodewgroup will initially create `minSize` instances.
     *
     * @default 2
     * @experimental
     */
    readonly desiredSize?: number;
    /**
     * (experimental) The maximum number of worker nodes that the managed node group can scale out to.
     *
     * Managed node groups can support up to 100 nodes by default.
     *
     * @default - desiredSize
     * @experimental
     */
    readonly maxSize?: number;
    /**
     * (experimental) The minimum number of worker nodes that the managed node group can scale in to.
     *
     * This number must be greater than zero.
     *
     * @default 1
     * @experimental
     */
    readonly minSize?: number;
    /**
     * (experimental) Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
     *
     * If an update fails because pods could not be drained, you can force the update after it fails to terminate the old
     * node whether or not any pods are
     * running on the node.
     *
     * @default true
     * @experimental
     */
    readonly forceUpdate?: boolean;
    /**
     * (deprecated) The instance type to use for your node group.
     *
     * Currently, you can specify a single instance type for a node group.
     * The default value for this parameter is `t3.medium`. If you choose a GPU instance type, be sure to specify the
     * `AL2_x86_64_GPU` with the amiType parameter.
     *
     * @default t3.medium
     * @deprecated Use `instanceTypes` instead.
     */
    readonly instanceType?: InstanceType;
    /**
     * (experimental) The instance types to use for your node group.
     *
     * @default t3.medium will be used according to the cloudformation document.
     * @see - https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes
     * @experimental
     */
    readonly instanceTypes?: InstanceType[];
    /**
     * (experimental) The Kubernetes labels to be applied to the nodes in the node group when they are created.
     *
     * @default - None
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * (experimental) The IAM role to associate with your node group.
     *
     * The Amazon EKS worker node kubelet daemon
     * makes calls to AWS APIs on your behalf. Worker nodes receive permissions for these API calls through
     * an IAM instance profile and associated policies. Before you can launch worker nodes and register them
     * into a cluster, you must create an IAM role for those worker nodes to use when they are launched.
     *
     * @default - None. Auto-generated if not specified.
     * @experimental
     */
    readonly nodeRole?: IRole;
    /**
     * (experimental) The AMI version of the Amazon EKS-optimized AMI to use with your node group (for example, `1.14.7-YYYYMMDD`).
     *
     * @default - The latest available AMI version for the node group's current Kubernetes version is used.
     * @experimental
     */
    readonly releaseVersion?: string;
    /**
     * (experimental) The remote access (SSH) configuration to use with your node group.
     *
     * Disabled by default, however, if you
     * specify an Amazon EC2 SSH key but do not specify a source security group when you create a managed node group,
     * then port 22 on the worker nodes is opened to the internet (0.0.0.0/0)
     *
     * @default - disabled
     * @experimental
     */
    readonly remoteAccess?: NodegroupRemoteAccess;
    /**
     * (experimental) The metadata to apply to the node group to assist with categorization and organization.
     *
     * Each tag consists of
     * a key and an optional value, both of which you define. Node group tags do not propagate to any other resources
     * associated with the node group, such as the Amazon EC2 instances or subnets.
     *
     * @default - None
     * @experimental
     */
    readonly tags?: {
        [name: string]: string;
    };
    /**
     * (experimental) Launch template specification used for the nodegroup.
     *
     * @default - no launch template
     * @see - https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html
     * @experimental
     */
    readonly launchTemplateSpec?: LaunchTemplateSpec;
    /**
     * (experimental) The capacity type of the nodegroup.
     *
     * @default - ON_DEMAND
     * @experimental
     */
    readonly capacityType?: CapacityType;
}
/**
 * (experimental) NodeGroup properties interface.
 *
 * @experimental
 */
export interface NodegroupProps extends NodegroupOptions {
    /**
     * (experimental) Cluster resource.
     *
     * @experimental
     */
    readonly cluster: ICluster;
}
/**
 * (experimental) The Nodegroup resource class.
 *
 * @experimental
 */
export declare class Nodegroup extends Resource implements INodegroup {
    /**
     * (experimental) Import the Nodegroup from attributes.
     *
     * @experimental
     */
    static fromNodegroupName(scope: Construct, id: string, nodegroupName: string): INodegroup;
    /**
     * (experimental) ARN of the nodegroup.
     *
     * @experimental
     * @attribute true
     */
    readonly nodegroupArn: string;
    /**
     * (experimental) Nodegroup name.
     *
     * @experimental
     * @attribute true
     */
    readonly nodegroupName: string;
    /**
     * (experimental) the Amazon EKS cluster resource.
     *
     * @experimental
     * @attribute ClusterName
     */
    readonly cluster: ICluster;
    /**
     * (experimental) IAM role of the instance profile for the nodegroup.
     *
     * @experimental
     */
    readonly role: IRole;
    private readonly desiredSize;
    private readonly maxSize;
    private readonly minSize;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NodegroupProps);
}
