import * as iam from "../../aws-iam";
import { NestedStack } from "../../core";
import { Construct } from 'constructs';
import { ICluster } from './cluster';
export interface KubectlProviderProps {
    /**
     * The cluster to control.
     */
    readonly cluster: ICluster;
}
export declare class KubectlProvider extends NestedStack {
    static getOrCreate(scope: Construct, cluster: ICluster): KubectlProvider;
    /**
     * The custom resource provider's service token.
     */
    readonly serviceToken: string;
    /**
     * The IAM role to assume in order to perform kubectl operations against this cluster.
     */
    readonly roleArn: string;
    /**
     * The IAM execution role of the handler.
     */
    readonly handlerRole: iam.IRole;
    constructor(scope: Construct, id: string, props: KubectlProviderProps);
}
