"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesObjectValue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Represents a value of a specific object deployed in the cluster.
 *
 * Use this to fetch any information available by the `kubectl get` command.
 *
 * @experimental
 */
class KubernetesObjectValue extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        this._resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: KubernetesObjectValue.RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                ObjectType: props.objectType,
                ObjectName: props.objectName,
                ObjectNamespace: (_b = props.objectNamespace) !== null && _b !== void 0 ? _b : 'default',
                JsonPath: props.jsonPath,
                TimeoutSeconds: ((_c = props === null || props === void 0 ? void 0 : props.timeout) !== null && _c !== void 0 ? _c : core_1.Duration.minutes(5)).toSeconds(),
            },
        });
    }
    /**
     * (experimental) The value as a string token.
     *
     * @experimental
     */
    get value() {
        return core_1.Token.asString(this._resource.getAtt('Value'));
    }
}
exports.KubernetesObjectValue = KubernetesObjectValue;
_a = JSII_RTTI_SYMBOL_1;
KubernetesObjectValue[_a] = { fqn: "monocdk.aws_eks.KubernetesObjectValue", version: "1.106.1" };
/**
 * (experimental) The CloudFormation reosurce type.
 *
 * @experimental
 */
KubernetesObjectValue.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesObjectValue';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiazhzLW9iamVjdC12YWx1ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIms4cy1vYmplY3QtdmFsdWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxQ0FBNkQsQ0FBQyxnREFBZ0Q7QUFHOUcseURBQXFEO0FBQ3JELGdIQUFnSDtBQUNoSCwyQkFBMkI7QUFDM0IscUNBQXdELENBQUMsZ0RBQWdEOzs7Ozs7OztBQTBDekcsTUFBYSxxQkFBc0IsU0FBUSxnQkFBYTs7OztJQU1wRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlDOztRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sUUFBUSxHQUFHLGtDQUFlLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDbEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsRCxZQUFZLEVBQUUscUJBQXFCLENBQUMsYUFBYTtZQUNqRCxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsVUFBVSxFQUFFO2dCQUNSLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RDLE9BQU8sRUFBRSxRQUFRLENBQUMsT0FBTztnQkFDekIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO2dCQUM1QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7Z0JBQzVCLGVBQWUsUUFBRSxLQUFLLENBQUMsZUFBZSxtQ0FBSSxTQUFTO2dCQUNuRCxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7Z0JBQ3hCLGNBQWMsRUFBRSxPQUFDLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLG1DQUFJLGVBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUU7YUFDdEU7U0FDSixDQUFDLENBQUM7SUFDUCxDQUFDOzs7Ozs7SUFJRCxJQUFXLEtBQUs7UUFDWixPQUFPLFlBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUMxRCxDQUFDOztBQTVCTCxzREE2QkM7Ozs7Ozs7O0FBekIwQixtQ0FBYSxHQUFHLDBDQUEwQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ3VzdG9tUmVzb3VyY2UsIFRva2VuLCBEdXJhdGlvbiB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJQ2x1c3RlciB9IGZyb20gJy4vY2x1c3Rlcic7XG5pbXBvcnQgeyBLdWJlY3RsUHJvdmlkZXIgfSBmcm9tICcuL2t1YmVjdGwtcHJvdmlkZXInO1xuLy8gdjIgLSBrZWVwIHRoaXMgaW1wb3J0IGFzIGEgc2VwYXJhdGUgc2VjdGlvbiB0byByZWR1Y2UgbWVyZ2UgY29uZmxpY3Qgd2hlbiBmb3J3YXJkIG1lcmdpbmcgd2l0aCB0aGUgdjIgYnJhbmNoLlxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG5pbXBvcnQgeyBDb25zdHJ1Y3QgYXMgQ29yZUNvbnN0cnVjdCB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEt1YmVybmV0ZXNPYmplY3RWYWx1ZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGNsdXN0ZXI6IElDbHVzdGVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBvYmplY3RUeXBlOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgb2JqZWN0TmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBvYmplY3ROYW1lc3BhY2U/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGpzb25QYXRoOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgdGltZW91dD86IER1cmF0aW9uO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBLdWJlcm5ldGVzT2JqZWN0VmFsdWUgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRVNPVVJDRV9UWVBFID0gJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzT2JqZWN0VmFsdWUnO1xuICAgIHByaXZhdGUgX3Jlc291cmNlOiBDdXN0b21SZXNvdXJjZTtcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogS3ViZXJuZXRlc09iamVjdFZhbHVlUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgY29uc3QgcHJvdmlkZXIgPSBLdWJlY3RsUHJvdmlkZXIuZ2V0T3JDcmVhdGUodGhpcywgcHJvcHMuY2x1c3Rlcik7XG4gICAgICAgIHRoaXMuX3Jlc291cmNlID0gbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIHJlc291cmNlVHlwZTogS3ViZXJuZXRlc09iamVjdFZhbHVlLlJFU09VUkNFX1RZUEUsXG4gICAgICAgICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICBDbHVzdGVyTmFtZTogcHJvcHMuY2x1c3Rlci5jbHVzdGVyTmFtZSxcbiAgICAgICAgICAgICAgICBSb2xlQXJuOiBwcm92aWRlci5yb2xlQXJuLFxuICAgICAgICAgICAgICAgIE9iamVjdFR5cGU6IHByb3BzLm9iamVjdFR5cGUsXG4gICAgICAgICAgICAgICAgT2JqZWN0TmFtZTogcHJvcHMub2JqZWN0TmFtZSxcbiAgICAgICAgICAgICAgICBPYmplY3ROYW1lc3BhY2U6IHByb3BzLm9iamVjdE5hbWVzcGFjZSA/PyAnZGVmYXVsdCcsXG4gICAgICAgICAgICAgICAgSnNvblBhdGg6IHByb3BzLmpzb25QYXRoLFxuICAgICAgICAgICAgICAgIFRpbWVvdXRTZWNvbmRzOiAocHJvcHM/LnRpbWVvdXQgPz8gRHVyYXRpb24ubWludXRlcyg1KSkudG9TZWNvbmRzKCksXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgZ2V0IHZhbHVlKCk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyh0aGlzLl9yZXNvdXJjZS5nZXRBdHQoJ1ZhbHVlJykpO1xuICAgIH1cbn1cbiJdfQ==