"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
/**
 * (experimental) Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @experimental
 */
class FargateCluster extends cluster_1.Cluster {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            coreDnsComputeType: (_b = props.coreDnsComputeType) !== null && _b !== void 0 ? _b : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_d = (_c = props.defaultProfile) === null || _c === void 0 ? void 0 : _c.fargateProfileName) !== null && _d !== void 0 ? _d : (props.defaultProfile ? 'custom' : 'default'), (_e = props.defaultProfile) !== null && _e !== void 0 ? _e : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
_a = JSII_RTTI_SYMBOL_1;
FargateCluster[_a] = { fqn: "monocdk.aws_eks.FargateCluster", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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