"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const crypto = require("crypto");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: KUBECTL_APP_ARN,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : '8C2542BC-BF2B-4DFE-B765-E181FD30A9A0');
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    addPermission(_id, _permission) {
        return;
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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