import { Cluster } from './cluster';
import { Construct } from "../../core";
/**
 * (experimental) Helm Chart options.
 *
 * @experimental
 */
export interface HelmChartOptions {
    /**
     * (experimental) The name of the chart.
     *
     * @experimental
     */
    readonly chart: string;
    /**
     * (experimental) The name of the release.
     *
     * @default - If no release name is given, it will use the last 63 characters of the node's unique id.
     * @experimental
     */
    readonly release?: string;
    /**
     * (experimental) The chart version to install.
     *
     * @default - If this is not specified, the latest version is installed
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The repository which contains the chart.
     *
     * For example: https://kubernetes-charts.storage.googleapis.com/
     *
     * @default - No repository will be used, which means that the chart needs to be an absolute URL.
     * @experimental
     */
    readonly repository?: string;
    /**
     * (experimental) The Kubernetes namespace scope of the requests.
     *
     * @default default
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) The values to be used by the chart.
     *
     * @default - No values are provided to the chart.
     * @experimental
     */
    readonly values?: {
        [key: string]: any;
    };
}
/**
 * (experimental) Helm Chart properties.
 *
 * @experimental
 */
export interface HelmChartProps extends HelmChartOptions {
    /**
     * (experimental) The EKS cluster to apply this configuration to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: Cluster;
}
/**
 * (experimental) Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 *
 * @experimental
 */
export declare class HelmChart extends Construct {
    /**
     * (experimental) The CloudFormation reosurce type.
     *
     * @experimental
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-HelmChart";
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HelmChartProps);
    private getOrCreateHelmChartHandler;
}
