"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EFSMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class EFSMetrics {
    static dataReadIoBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'DataReadIOBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static dataWriteIoBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'DataWriteIOBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static clientConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'ClientConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static burstCreditBalanceAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'BurstCreditBalance',
            dimensions,
            statistic: 'Average',
        };
    }
    static percentIoLimitAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'PercentIOLimit',
            dimensions,
            statistic: 'Average',
        };
    }
    static permittedThroughputAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'PermittedThroughput',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EFSMetrics = EFSMetrics;
//# sourceMappingURL=data:application/json;base64,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