"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplunkLogDriver = exports.SplunkLogFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * (experimental) Log Message Format.
 *
 * @experimental
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * (experimental) A log driver that sends log information to splunk Logs.
 *
 * @experimental
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * (experimental) Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions({
                'splunk-token': this.props.token,
                'splunk-url': this.props.url,
                'splunk-source': this.props.source,
                'splunk-sourcetype': this.props.sourceType,
                'splunk-index': this.props.index,
                'splunk-capath': this.props.caPath,
                'splunk-caname': this.props.caName,
                'splunk-insecureskipverify': this.props.insecureSkipVerify,
                'splunk-format': this.props.format,
                'splunk-verify-connection': this.props.verifyConnection,
                'splunk-gzip': this.props.gzip,
                'splunk-gzip-level': this.props.gzipLevel,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
_a = JSII_RTTI_SYMBOL_1;
SplunkLogDriver[_a] = { fqn: "monocdk.aws_ecs.SplunkLogDriver", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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