"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * (experimental) The base class for log drivers.
 *
 * @experimental
 */
class LogDrivers {
    /**
     * (experimental) Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @experimental
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to fluentd Logs.
     *
     * @experimental
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to gelf Logs.
     *
     * @experimental
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to journald Logs.
     *
     * @experimental
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to json-file Logs.
     *
     * @experimental
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to splunk Logs.
     *
     * @experimental
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to syslog Logs.
     *
     * @experimental
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to firelens log router.
     *
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     *
     * @experimental
     */
    static firelens(props) {
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
_a = JSII_RTTI_SYMBOL_1;
LogDrivers[_a] = { fqn: "monocdk.aws_ecs.LogDrivers", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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