import { AwsLogDriverProps } from './aws-log-driver';
import { FireLensLogDriverProps } from './firelens-log-driver';
import { FluentdLogDriverProps } from './fluentd-log-driver';
import { GelfLogDriverProps } from './gelf-log-driver';
import { JournaldLogDriverProps } from './journald-log-driver';
import { JsonFileLogDriverProps } from './json-file-log-driver';
import { LogDriver } from './log-driver';
import { SplunkLogDriverProps } from './splunk-log-driver';
import { SyslogLogDriverProps } from './syslog-log-driver';
/**
 * (experimental) The base class for log drivers.
 *
 * @experimental
 */
export declare class LogDrivers {
    /**
     * (experimental) Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @experimental
     */
    static awsLogs(props: AwsLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to fluentd Logs.
     *
     * @experimental
     */
    static fluentd(props?: FluentdLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to gelf Logs.
     *
     * @experimental
     */
    static gelf(props: GelfLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to journald Logs.
     *
     * @experimental
     */
    static journald(props?: JournaldLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to json-file Logs.
     *
     * @experimental
     */
    static jsonFile(props?: JsonFileLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to splunk Logs.
     *
     * @experimental
     */
    static splunk(props: SplunkLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to syslog Logs.
     *
     * @experimental
     */
    static syslog(props?: SyslogLogDriverProps): LogDriver;
    /**
     * (experimental) Creates a log driver configuration that sends log information to firelens log router.
     *
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     *
     * @experimental
     */
    static firelens(props: FireLensLogDriverProps): LogDriver;
}
