"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournaldLogDriver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * (experimental) A log driver that sends log information to journald Logs.
 *
 * @experimental
 */
class JournaldLogDriver extends log_driver_1.LogDriver {
    /**
     * (experimental) Constructs a new instance of the JournaldLogDriver class.
     *
     * @param props the journald log driver configuration options.
     * @experimental
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'journald',
            options: utils_1.stringifyOptions({
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.JournaldLogDriver = JournaldLogDriver;
_a = JSII_RTTI_SYMBOL_1;
JournaldLogDriver[_a] = { fqn: "monocdk.aws_ecs.JournaldLogDriver", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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